package com.elitesland.cloudt.authorization.api.provider.security.grant.mobile_pwd;

import com.elitesland.cloudt.authorization.api.client.common.AuthorizationException;
import com.elitesland.cloudt.authorization.api.provider.security.grant.AbstractCustomAuthenticationProvider;
import com.elitesland.yst.security.entity.GeneralUserDetails;
import lombok.extern.log4j.Log4j2;
import org.springframework.lang.NonNull;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.util.StringUtils;

/**
 * 手机号和密码的身份认证.
 *
 * @author Kaiser（wang shao）
 * @date 2022/01/01
 */
@Log4j2
public class MobilePasswordAuthenticationProvider extends AbstractCustomAuthenticationProvider<MobilePasswordAuthenticationToken> {

    @NonNull
    @Override
    protected GeneralUserDetails retrieveUser(MobilePasswordAuthenticationToken authentication) throws AuthenticationException {
        String mobile = (String) authentication.getPrincipal();
        if (!StringUtils.hasText(mobile)) {
            throw new AuthorizationException("手机号为空");
        }

        return userDetailManager.loadUserByMobile(mobile);
    }

    @Override
    protected void additionalAuthenticationChecks(GeneralUserDetails userDetails, MobilePasswordAuthenticationToken authentication) throws AuthenticationException {
        super.additionalAuthenticationChecks(userDetails, authentication);

        if (authentication.getCredentials() == null) {
            log.debug("Failed to authenticate since no credentials provided");
            throw new BadCredentialsException("手机号或密码不正确");
        }
        String presentedPassword = authentication.getCredentials().toString();
        if (!this.passwordEncoder.matches(presentedPassword, userDetails.getPassword())) {
            log.debug("Failed to authenticate since password does not match stored value");
            throw new BadCredentialsException("手机号或密码不正确");
        }
    }
}
