package com.elitesland.cloudt.authorization.api.provider.security.grant.mobile_pwd;

import com.elitesland.cloudt.authorization.api.client.util.HttpServletUtil;
import com.elitesland.cloudt.authorization.api.provider.common.CustomOAuth2ParameterNames;
import com.elitesland.cloudt.authorization.api.provider.common.LoginType;
import com.elitesland.cloudt.authorization.api.provider.security.grant.AbstractCustomAuthenticationToken;
import com.elitesland.yst.common.constant.Terminal;
import org.springframework.lang.NonNull;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.core.endpoint.OAuth2ParameterNames;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

import javax.servlet.http.HttpServletRequest;
import java.util.Collection;

/**
 * 手机号密码的身份认证令牌.
 *
 * @author Kaiser（wang shao）
 * @date 2022/01/01
 */
public class MobilePasswordAuthenticationToken extends AbstractCustomAuthenticationToken<MobilePasswordAuthenticationToken> {
    private static final long serialVersionUID = -2118788872828941269L;

    public MobilePasswordAuthenticationToken() {
        super(null, null);
    }

    public MobilePasswordAuthenticationToken(Object principal, Object credentials) {
        super(principal, credentials);
    }

    public MobilePasswordAuthenticationToken(Object principal, Object credentials, Collection<? extends GrantedAuthority> authorities) {
        super(principal, credentials, authorities);
    }

    @NonNull
    @Override
    public LoginType loginType() {
        return LoginType.MOBILE_PWD;
    }

    @NonNull
    @Override
    public MobilePasswordAuthenticationToken convert(@NonNull HttpServletRequest request) {
        MultiValueMap<String, String> parameters = HttpServletUtil.getParameters(request);
        String terminalParam = parameters.getFirst(CustomOAuth2ParameterNames.TERMINAL);
        Terminal terminal = null;
        if (StringUtils.hasText(terminalParam)) {
            terminal = Terminal.parse(terminalParam);
        }

        MobilePasswordAuthenticationToken authenticationToken = new MobilePasswordAuthenticationToken();
        authenticationToken.setTerminal(terminal);
        authenticationToken.setPrincipal(parameters.getFirst(CustomOAuth2ParameterNames.MOBILE));
        authenticationToken.setCredentials(parameters.getFirst(OAuth2ParameterNames.PASSWORD));
        authenticationToken.setAuthenticated(false);

        return authenticationToken;
    }
}
