package com.elitesland.cloudt.authorization.api.provider.security.grant.mobile_sms;

import com.elitesland.cloudt.authorization.api.client.common.AuthorizationException;
import com.elitesland.cloudt.authorization.api.provider.config.system.SmsCodeEnum;
import com.elitesland.cloudt.authorization.api.provider.provider.sms.SmsCodeProvider;
import com.elitesland.cloudt.authorization.api.provider.security.grant.AbstractCustomAuthenticationProvider;
import com.elitesland.yst.security.entity.GeneralUserDetails;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.NonNull;
import org.springframework.security.core.AuthenticationException;
import org.springframework.util.StringUtils;

/**
 * 手机号和短信的身份证认证.
 *
 * @author Kaiser（wang shao）
 * @date 2022/01/01
 */
public class MobileSmsAuthenticationProvider extends AbstractCustomAuthenticationProvider<MobileSmsAuthenticationToken> {

    @Autowired
    private SmsCodeProvider smsCodeManager;

    @NonNull
    @Override
    protected GeneralUserDetails retrieveUser(MobileSmsAuthenticationToken authentication) throws AuthenticationException {
        String mobile = (String) authentication.getPrincipal();
        if (!StringUtils.hasText(mobile)) {
            throw new AuthorizationException("手机号为空");
        }

        String smsCode = (String) authentication.getCredentials();
        if (!StringUtils.hasText(smsCode)) {
            throw new AuthorizationException("验证码为空");
        }

        // 校验短信验证码
        boolean verify = smsCodeManager.verify(SmsCodeEnum.LOGIN, mobile, smsCode);
        if (!verify) {
            throw new AuthorizationException("验证码不正确");
        }

        return userDetailManager.loadUserByMobile(mobile);
    }
}
