package com.elitesland.cloudt.authorization.api.provider.security.grant.mobile_sms;

import com.elitesland.cloudt.authorization.api.client.util.HttpServletUtil;
import com.elitesland.cloudt.authorization.api.provider.common.CustomOAuth2ParameterNames;
import com.elitesland.cloudt.authorization.api.provider.common.LoginType;
import com.elitesland.cloudt.authorization.api.provider.security.grant.AbstractCustomAuthenticationToken;
import com.elitesland.yst.common.constant.Terminal;
import org.springframework.lang.NonNull;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

import javax.servlet.http.HttpServletRequest;
import java.util.Collection;

/**
 * 手机号和短信的身份认证令牌.
 *
 * @author Kaiser（wang shao）
 * @date 2022/01/01
 */
public class MobileSmsAuthenticationToken extends AbstractCustomAuthenticationToken<MobileSmsAuthenticationToken> {
    private static final long serialVersionUID = -8359205420429608593L;

    public MobileSmsAuthenticationToken() {
        super(null, null);
    }

    public MobileSmsAuthenticationToken(Object principal, Object credentials) {
        super(principal, credentials);
    }

    public MobileSmsAuthenticationToken(Object principal, Object credentials, Collection<? extends GrantedAuthority> authorities) {
        super(principal, credentials, authorities);
    }

    @NonNull
    @Override
    public LoginType loginType() {
        return LoginType.MOBILE_SMS;
    }

    @NonNull
    @Override
    public MobileSmsAuthenticationToken convert(@NonNull HttpServletRequest request) {
        MultiValueMap<String, String> parameters = HttpServletUtil.getParameters(request);
        String terminalParam = parameters.getFirst(CustomOAuth2ParameterNames.TERMINAL);
        Terminal terminal = null;
        if (StringUtils.hasText(terminalParam)) {
            terminal = Terminal.parse(terminalParam);
        }

        MobileSmsAuthenticationToken authenticationToken = new MobileSmsAuthenticationToken();
        authenticationToken.setTerminal(terminal);
        authenticationToken.setPrincipal(parameters.getFirst(CustomOAuth2ParameterNames.MOBILE));
        authenticationToken.setCredentials(parameters.getFirst(CustomOAuth2ParameterNames.MOBILE_SMS_CODE));
        authenticationToken.setAuthenticated(false);

        return authenticationToken;
    }
}
