package com.elitesland.cloudt.authorization.api.provider.security.grant.wx_minapp;

import com.elitesland.cloudt.authorization.api.client.common.AuthorizationException;
import com.elitesland.cloudt.authorization.api.provider.provider.user.UserDetailManager;
import com.elitesland.cloudt.authorization.api.provider.provider.wechat.WechatAppletService;
import com.elitesland.cloudt.authorization.api.provider.security.grant.AbstractCustomAuthenticationProvider;
import com.elitesland.yst.security.entity.GeneralUserDetails;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.AuthenticationException;
import org.springframework.util.StringUtils;

/**
 * 微信openid的身份认证.
 *
 * @author Kaiser（wang shao）
 * @date 2022/01/01
 */
@Log4j2
public class WechatOpenidAuthenticationProvider extends AbstractCustomAuthenticationProvider<WechatOpenidAuthenticationToken> {

    @Autowired
    private WechatAppletService wechatAppletService;
    @Autowired
    private UserDetailManager userDetailManager;

    @Override
    protected GeneralUserDetails retrieveUser(WechatOpenidAuthenticationToken authentication) throws AuthenticationException {
        String appId = (String) authentication.getPrincipal();
        String wxCode = (String) authentication.getCredentials();
        if (!StringUtils.hasText(appId) || !StringUtils.hasText(wxCode)) {
            throw new AuthorizationException("请求有误，参数不完整");
        }

        // 调用微信接口，根据wxCode获得用户的openId
        String openId = obtainOpenid(appId, wxCode);

        return userDetailManager.loadUserByWechatOpenid(openId);
    }

    private String obtainOpenid(String appId, String wxCode) {
        var loginResult = wechatAppletService.login(appId, wxCode);
        if (loginResult.getData() == null || !StringUtils.hasText(loginResult.getData().getOpenid())) {
            throw new AuthorizationException("登录失败：" + loginResult.getMsg());
        }

        return loginResult.getData().getOpenid();
    }
}
