package com.elitesland.cloudt.authorization.api.provider.security.grant.wx_minapp;

import com.elitesland.cloudt.authorization.api.client.util.HttpServletUtil;
import com.elitesland.cloudt.authorization.api.provider.common.CustomOAuth2ParameterNames;
import com.elitesland.cloudt.authorization.api.provider.common.LoginType;
import com.elitesland.cloudt.authorization.api.provider.security.grant.AbstractCustomAuthenticationToken;
import com.elitesland.yst.common.constant.Terminal;
import org.springframework.lang.NonNull;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

import javax.servlet.http.HttpServletRequest;
import java.util.Collection;

/**
 * 微信openid的身份认证令牌.
 *
 * @author Kaiser（wang shao）
 * @date 2022/01/01
 */
public class WechatOpenidAuthenticationToken extends AbstractCustomAuthenticationToken<WechatOpenidAuthenticationToken> {
    private static final long serialVersionUID = 35697051927011289L;

    public WechatOpenidAuthenticationToken() {
        super(null, null);
    }

    public WechatOpenidAuthenticationToken(Object principal, Object credentials) {
        super(principal, credentials);
    }

    public WechatOpenidAuthenticationToken(Object principal, Object credentials, Collection<? extends GrantedAuthority> authorities) {
        super(principal, credentials, authorities);
    }

    @NonNull
    @Override
    public LoginType loginType() {
        return LoginType.WX_MINAPP;
    }

    @NonNull
    @Override
    public WechatOpenidAuthenticationToken convert(@NonNull HttpServletRequest request) {
        MultiValueMap<String, String> parameters = HttpServletUtil.getParameters(request);
        String terminalParam = parameters.getFirst(CustomOAuth2ParameterNames.TERMINAL);
        Terminal terminal = null;
        if (StringUtils.hasText(terminalParam)) {
            terminal = Terminal.parse(terminalParam);
        }

        WechatOpenidAuthenticationToken authenticationToken = new WechatOpenidAuthenticationToken();
        authenticationToken.setTerminal(terminal);
        authenticationToken.setPrincipal(parameters.getFirst(CustomOAuth2ParameterNames.WECHAT_APPID));
        authenticationToken.setCredentials(parameters.getFirst(CustomOAuth2ParameterNames.WECHAT_CODE));
        authenticationToken.setAuthenticated(false);

        return authenticationToken;
    }
}
