package com.elitesland.cloudt.authorization.api.provider.security.handler.oauth2.server;

import com.elitesland.yst.common.base.ApiResult;
import lombok.extern.log4j.Log4j2;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.endpoint.OAuth2ParameterNames;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeRequestAuthenticationException;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeRequestAuthenticationToken;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.util.StringUtils;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/**
 * OAuth2服务端认证失败处理器.
 *
 * @author Kaiser（wang shao）
 * @date 2022/7/3
 */
@Log4j2
public class OAuth2ServerErrorResponseHandler extends AbstractOAuth2ServerHandler implements AuthenticationFailureHandler {

    @Override
    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        if (supportRedirect(request)) {
            // 支持重定向，则调用原OAuth2的逻辑进行重定向
            sendErrorResponse(request, response, exception);
            return;
        }

        // 不支持重定向，则返回json格式数据
        sendErrorResponseByJson(request, response, exception);
    }

    private void sendErrorResponseByJson(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException {
        OAuth2AuthorizationCodeRequestAuthenticationException authorizationCodeRequestAuthenticationException =
                (OAuth2AuthorizationCodeRequestAuthenticationException) exception;
        OAuth2Error error = authorizationCodeRequestAuthenticationException.getError();
        OAuth2AuthorizationCodeRequestAuthenticationToken authorizationCodeRequestAuthentication =
                authorizationCodeRequestAuthenticationException.getAuthorizationCodeRequestAuthentication();
        // 请求方式有误
        if (authorizationCodeRequestAuthentication == null) {
            writeResponse(response, ApiResult.fail("请求方式或参数有误"), HttpStatus.BAD_REQUEST);
            return;
        }

        // 请求有误
        Map<String, Object> result = new HashMap<>();
        result.put(OAuth2ParameterNames.ERROR, error.getErrorCode());
        if (StringUtils.hasText(error.getDescription())) {
            result.put(OAuth2ParameterNames.ERROR_DESCRIPTION, error.getDescription());
        }
        if (StringUtils.hasText(error.getUri())) {
            result.put(OAuth2ParameterNames.ERROR_URI, error.getUri());
        }
        if (StringUtils.hasText(authorizationCodeRequestAuthentication.getState())) {
            result.put(OAuth2ParameterNames.STATE, authorizationCodeRequestAuthentication.getState());
        }

        writeResponse(response, ApiResult.ok(result), HttpStatus.UNAUTHORIZED);
    }

}
