package com.elitesland.cloudt.authorization.api.provider.security.handler.oauth2.server.support;

import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeRequestAuthenticationToken;

import java.time.Duration;

/**
 * 授权码认证请求缓存.
 *
 * @author Kaiser（wang shao）
 * @date 2022/7/3
 */
public interface OAuth2AuthorizationCodeRequestCache {

    /**
     * 设置缓存
     *
     * @param state
     * @param authenticationToken
     * @param timeToLive
     */
    void setAuthenticationToken(String state, OAuth2AuthorizationCodeRequestAuthenticationToken authenticationToken, Duration timeToLive);

    /**
     * 获取缓存
     *
     * @param state
     * @return
     */
    OAuth2AuthorizationCodeRequestAuthenticationToken getAuthenticationToken(String state);

    /**
     * 移除缓存
     *
     * @param state
     */
    void removeAuthenticationToken(String state);
}
