package com.elitesland.cloudt.authorization.api.provider.security.impl;

import com.elitesland.cloudt.authorization.api.client.common.AuthorizationException;
import com.elitesland.cloudt.authorization.api.provider.config.system.ConfigProperties;
import com.elitesland.cloudt.authorization.api.provider.security.AuthenticationCheckService;
import com.elitesland.cloudt.authorization.api.provider.security.grant.AbstractCustomAuthenticationToken;
import com.elitesland.yst.common.constant.Terminal;
import com.elitesland.yst.security.entity.GeneralUserDetails;
import org.springframework.security.core.AuthenticationException;

/**
 * 默认的用户认证信息检查.
 *
 * @author Kaiser（wang shao）
 * @date 2022/6/20
 */
public class DefaultAuthenticationCheckServiceImpl<T extends AbstractCustomAuthenticationToken<T>> implements AuthenticationCheckService<T> {

    private final ConfigProperties configProperties;

    public DefaultAuthenticationCheckServiceImpl(ConfigProperties configProperties) {
        this.configProperties = configProperties;
    }

    @Override
    public void additionalAuthenticationChecks(GeneralUserDetails userDetails, T authentication) throws AuthenticationException {
        Boolean terminalEnabled = configProperties.getLogin().getTerminalEnabled();
        if (terminalEnabled == null || !terminalEnabled) {
            // 默认不校验
            return;
        }

        Terminal terminal = authentication.getTerminal();
        if (terminal == null) {
            throw new AuthorizationException("未设置登录终端");
        }

        var terminals = userDetails.getUser().getTerminals();
        if (terminals == null || terminals.isEmpty()) {
            throw new AuthorizationException("无权限登录该终端");
        }

        if (!terminals.contains(terminal)) {
            throw new AuthorizationException("无权限登录该终端");
        }
    }
}
