package com.elitesland.cloudt.authorization.api.provider.security.jackson.mixin.userdetails;

import com.elitesland.yst.security.dto.SecurityOrgUserEmpBuDTO;
import com.elitesland.yst.security.entity.GeneralUserDetails;
import com.elitesland.yst.system.dto.SysTenantDTO;
import com.elitesland.yst.system.vo.*;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.module.SimpleModule;

import java.io.Serial;

/**
 * 自定义jacksonModule.
 * <p>
 * 支持自定义UserDetails类的反序列化
 *
 * @author Kaiser（wang shao）
 * @date 2022/01/07
 */
public class OAuth2AuthorizationJacksonModule extends SimpleModule {
    @Serial
    private static final long serialVersionUID = -6049623617656953424L;

    public OAuth2AuthorizationJacksonModule() {
        super(OAuth2AuthorizationJacksonModule.class.getName(), new Version(1, 0, 0, null, null, null));
    }

    @Override
    public void setupModule(SetupContext context) {
        context.setMixInAnnotations(GeneralUserDetails.class, MixinGeneralUserDetails.class);
        context.setMixInAnnotations(SecurityOrgUserEmpBuDTO.class, MixinSecurityOrgUserEmpBuDTO.class);
        context.setMixInAnnotations(SysBizDataConstraintVO.class, MixinSysBizDataConstraintVO.class);
        context.setMixInAnnotations(SysDataRoleAuthScope.class, MixinSysDataRoleAuthScope.class);
        context.setMixInAnnotations(SysDataAuthVO.class, MixinSysDataAuthVO.class);
        context.setMixInAnnotations(SysDataRoleVO.class, MixinSysDataRoleVO.class);
        context.setMixInAnnotations(SysPermissionVO.class, MixinSysPermissionVO.class);
        context.setMixInAnnotations(SysRoleVO.class, MixinSysRoleVO.class);
        context.setMixInAnnotations(SysTenantDTO.class, MixinSysTenantDTO.class);
        context.setMixInAnnotations(SysUserDTO.class, MixinSysUserDTO.class);
        context.setMixInAnnotations(SysUserVO.class, MixinSysUserVO.class);
    }
}
