package com.elitesland.cloudt.authorization.api.provider.security.util;

import com.elitesland.cloudt.authorization.api.provider.security.jackson.mixin.grant.CustomAuthenticationTokenJacksonModule;
import com.elitesland.cloudt.authorization.api.provider.security.jackson.mixin.userdetails.OAuth2AuthorizationJacksonModule;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.security.jackson2.SecurityJackson2Modules;
import org.springframework.security.oauth2.server.authorization.JdbcOAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.jackson2.OAuth2AuthorizationServerJackson2Module;

import java.util.List;

/**
 * 自定义认证相关工具.
 *
 * @author Kaiser（wang shao）
 * @date 2022/6/21
 */
public class AuthenticationTool {

    private AuthenticationTool() {
    }

    /**
     * objectMapper构建工具类
     *
     * @return objectMapper
     */
    public static ObjectMapper buildObjectMapperForSecurity() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        List<Module> securityModules = SecurityJackson2Modules.getModules(JdbcOAuth2AuthorizationService.class.getClassLoader());
        objectMapper.registerModules(securityModules);
        objectMapper.registerModule(new OAuth2AuthorizationServerJackson2Module());
        objectMapper.registerModule(new OAuth2AuthorizationJacksonModule());
        objectMapper.registerModule(new CustomAuthenticationTokenJacksonModule());
        objectMapper.addMixIn(Long.class, Object.class);

        return objectMapper;
    }
}
