package com.elitesland.cloudt.authorization.api.provider.service.impl;

import com.elitesland.cloudt.authorization.api.provider.security.util.AuthenticationTool;
import com.elitesland.cloudt.context.util.DatetimeUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.extern.log4j.Log4j2;
import org.springframework.util.StringUtils;

import java.time.Instant;
import java.time.LocalDateTime;


/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2022/6/10
 */
@Log4j2
public abstract class BaseCustomAuthorizationService {

    private ObjectMapper objectMapper;

    protected String toJsonString(Object object) {
        if (object == null) {
            return null;
        }

        try {
            return getObjectMapper().writeValueAsString(object);
        } catch (JsonProcessingException e) {
            log.error("转json字符串出错：", e);
        }
        return null;
    }

    protected <T> T toJsonObj(String jsonString, TypeReference<T> typeReference) {
        if (!StringUtils.hasText(jsonString)) {
            return null;
        }

        try {
            return getObjectMapper().readValue(jsonString, typeReference);
        } catch (JsonProcessingException e) {
            log.error("json字符串转对象出错：", e);
        }
        return null;
    }

    protected LocalDateTime toLocalDateTime(Instant instant) {
        if (instant == null) {
            return null;
        }
        return instant.atZone(DatetimeUtil.SYS_ZONE_OFFSET).toLocalDateTime();
    }

    protected Instant toInstant(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return null;
        }

        return localDateTime.toInstant(DatetimeUtil.SYS_ZONE_OFFSET);
    }

    protected ObjectMapper getObjectMapper() {
        if (objectMapper != null) {
            return objectMapper;
        }
        objectMapper = AuthenticationTool.buildObjectMapperForSecurity();

        return objectMapper;
    }
}
