package com.elitesland.cloudt.authorization.api.provider.service.impl;

import com.elitesland.cloudt.authorization.api.provider.service.OAuth2AuthenticationService;
import com.elitesland.cloudt.authorization.api.provider.service.reposotory.OAuth2AuthenticationRepo;
import com.elitesland.cloudt.authorization.api.provider.service.reposotory.OAuth2AuthenticationRepoProc;
import com.elitesland.yst.core.annotation.TenantTransaction;
import com.elitesland.yst.core.annotation.common.TenantIsolateType;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2022/5/11
 */
@Service
@TenantTransaction(isolateType = TenantIsolateType.DEFAULT)
@Log4j2
public class OAuth2AuthenticationServiceImpl extends BaseCustomAuthorizationService implements OAuth2AuthenticationService {

    @Autowired
    private OAuth2AuthenticationRepo oAuth2AuthenticationRepo;
    @Autowired
    private OAuth2AuthenticationRepoProc oAuth2AuthenticationRepoProc;

    @Override
    public void deleteAllExpiredToken() {
        LocalDateTime expiredTime = LocalDateTime.now();
        oAuth2AuthenticationRepoProc.deleteByRefreshTokenExpiresAt(expiredTime);
    }
}
