package com.elitesland.cloudt.authorization.api.provider.service.reposotory;

import com.elitesland.cloudt.authorization.api.provider.model.entity.OAuth2AuthorizationDO;
import com.elitesland.cloudt.authorization.api.provider.model.entity.QOAuth2AuthorizationDO;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.oauth2.core.OAuth2TokenType;
import org.springframework.security.oauth2.core.endpoint.OAuth2ParameterNames;
import org.springframework.stereotype.Repository;

import java.time.LocalDateTime;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2022/5/11
 */
@Repository
public class OAuth2AuthenticationRepoProc {

    private static final QOAuth2AuthorizationDO QDO = QOAuth2AuthorizationDO.oAuth2AuthorizationDO;

    @Autowired
    private JPAQueryFactory jpaQueryFactory;

    /**
     * 根据ID删除
     *
     * @param id ID
     * @return 删除数量
     */
    public long delete(String id) {
        return jpaQueryFactory.delete(QDO)
                .where(QDO.id.eq(id))
                .execute();
    }

    /**
     * 删除过期的token
     *
     * @param expiredTime 过期时间
     * @return 删除结果
     */
    public long deleteByAccessTokenExpiresAt(LocalDateTime expiredTime) {
        return jpaQueryFactory.delete(QDO)
                .where(QDO.accessTokenExpiresAt.before(expiredTime))
                .execute()
                ;
    }

    /**
     * 删除过期的token
     *
     * @param expiredTime 过期时间
     * @return 删除结果
     */
    public long deleteByRefreshTokenExpiresAt(LocalDateTime expiredTime) {
        return jpaQueryFactory.delete(QDO)
                .where(QDO.refreshTokenExpiresAt.before(expiredTime))
                .execute()
                ;
    }

    /**
     * 删除过期的token
     *
     * @param expiredTime 过期时间
     * @return 删除结果
     */
    public long deleteByAuthorizationCodeExpiresAt(LocalDateTime expiredTime) {
        return jpaQueryFactory.delete(QDO)
                .where(QDO.authorizationCodeExpiresAt.before(expiredTime))
                .execute()
                ;
    }

    /**
     * 删除过期的token
     *
     * @param expiredTime 过期时间
     * @return 删除结果
     */
    public long deleteByOidcIdTokenExpiresAt(LocalDateTime expiredTime) {
        return jpaQueryFactory.delete(QDO)
                .where(QDO.oidcIdTokenExpiresAt.before(expiredTime))
                .execute()
                ;
    }

    /**
     * 获取token信息
     *
     * @param token
     * @param tokenType
     * @return
     */
    public OAuth2AuthorizationDO getByToken(String token, OAuth2TokenType tokenType) {
        Predicate predicate = null;

        if (tokenType == null) {
            predicate = QDO.authorizationCodeValue.eq(token)
                    .or(QDO.accessTokenValue.eq(token))
                    .or(QDO.refreshTokenValue.eq(token))
                    .or(QDO.oidcIdTokenValue.eq(token))
            ;
        } else if (OAuth2ParameterNames.STATE.equals(tokenType.getValue())) {
            predicate = QDO.state.eq(token);
        } else if (OAuth2ParameterNames.CODE.equals(tokenType.getValue())) {
            predicate = QDO.authorizationCodeValue.eq(token);
        } else if (OAuth2TokenType.ACCESS_TOKEN.equals(tokenType)) {
            predicate = QDO.accessTokenValue.eq(token);
        } else if (OAuth2TokenType.REFRESH_TOKEN.equals(tokenType)) {
            predicate = QDO.refreshTokenValue.eq(token);
        }

        return jpaQueryFactory.select(QDO)
                .from(QDO)
                .where(predicate)
                .limit(1)
                .fetchOne()
                ;
    }
}
