package com.elitesland.cloudt.authorization.api.provider.service.reposotory;

import com.elitesland.cloudt.authorization.api.provider.model.entity.OAuth2AuthorizationConsentDO;
import com.elitesland.cloudt.authorization.api.provider.model.entity.QOAuth2AuthorizationConsentDO;
import com.querydsl.jpa.impl.JPAQueryFactory;
import org.springframework.stereotype.Repository;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2022/6/10
 */
@Repository
public class OAuth2AuthorizationConsentRepoProc {

    private static final QOAuth2AuthorizationConsentDO QDO = QOAuth2AuthorizationConsentDO.oAuth2AuthorizationConsentDO;

    private final JPAQueryFactory jpaQueryFactory;

    public OAuth2AuthorizationConsentRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }

    public long delete(String registerClientId, String principalName) {
        return jpaQueryFactory.delete(QDO)
                .where(QDO.principalName.eq(principalName).and(QDO.registeredClientId.eq(registerClientId)))
                .execute();
    }

    public OAuth2AuthorizationConsentDO get(String registerClientId, String principalName) {
        return jpaQueryFactory.select(QDO)
                .from(QDO)
                .where(QDO.principalName.eq(principalName).and(QDO.registeredClientId.eq(registerClientId)))
                .limit(1)
                .fetchOne();
    }

    public String getId(String registerClientId, String principalName) {
        return jpaQueryFactory.select(QDO.id)
                .from(QDO)
                .where(QDO.principalName.eq(principalName).and(QDO.registeredClientId.eq(registerClientId)))
                .limit(1)
                .fetchOne();
    }
}
