package com.elitesland.cloudt.authorization.api.provider.service.reposotory;

import com.elitesland.cloudt.authorization.api.provider.model.entity.OAuth2RegisteredClientDO;
import com.elitesland.cloudt.authorization.api.provider.model.entity.QOAuth2RegisteredClientDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2022/6/10
 */
@Repository
public class OAuth2RegisteredClientRepoProc {

    private static final QOAuth2RegisteredClientDO QDO = QOAuth2RegisteredClientDO.oAuth2RegisteredClientDO;

    private final JPAQueryFactory jpaQueryFactory;

    public OAuth2RegisteredClientRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }

    public String getId(String clientId) {
        return jpaQueryFactory.select(QDO.id)
                .from(QDO)
                .where(QDO.clientId.eq(clientId))
                .limit(1)
                .fetchOne();
    }

    public OAuth2RegisteredClientDO getByClientId(String clientId) {
        return jpaQueryFactory.select(QDO)
                .from(QDO)
                .where(QDO.clientId.eq(clientId))
                .limit(1)
                .fetchOne();
    }

    public boolean existsClientId(String clientId, String id) {
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(QDO.clientId.eq(clientId));
        if (StringUtils.hasText(id)) {
            predicates.add(QDO.id.ne(id));
        }

        return jpaQueryFactory.select(QDO.id)
                .from(QDO)
                .where(ExpressionUtils.allOf(predicates))
                .limit(1)
                .fetchOne() != null;
    }
}
