package com.elitesland.cloudt.authorization.api.provider.web.controller;

import com.elitesland.cloudt.authorization.api.provider.model.vo.resp.CaptchaRespVO;
import com.elitesland.cloudt.authorization.api.provider.provider.LoginSupportProvider;
import com.elitesland.yst.common.base.ApiResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * 登录扩展支撑.
 *
 * @author Kaiser（wang shao）
 * @date 2022/01/08
 */
@ResponseBody
@RequestMapping(value = "/oauth/login")
public class CommonLoginSupportController {

    private final LoginSupportProvider loginSupportProvider;

    public CommonLoginSupportController(LoginSupportProvider loginSupportProvider) {
        this.loginSupportProvider = loginSupportProvider;
    }

    /**
     * 获取登录验证码
     *
     * @return 验证码信息
     */
    @GetMapping(value = "/captcha")
    public ApiResult<CaptchaRespVO> getCaptcha() {
        return loginSupportProvider.generateCaptcha();
    }

    /**
     * 发送登录短信验证码
     *
     * @return 发送结果
     */
    @GetMapping(value = "/captcha/sms")
    public ApiResult<String> getCaptchaSms(String mobile) {
        return loginSupportProvider.sendSmsCode(mobile);
    }
}
