package com.elitesland.cloudt.authorization.api.provider.web.controller;

import com.elitesland.cloudt.authorization.api.provider.AuthenticationService;
import com.elitesland.yst.common.base.ApiResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * 登录相关接口支撑.
 *
 * @author Kaiser（wang shao）
 * @date 2022/7/6
 */
@ResponseBody
@RequestMapping(value = "/oauth/login")
public class LoginSupportController {

    private final AuthenticationService authenticationService;

    public LoginSupportController(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    /**
     * 注销
     *
     * @return 退出账号
     */
    @GetMapping(value = "/logout")
    public ApiResult<String> logout() {
        String principal = authenticationService.logout();
        return ApiResult.ok(principal);
    }
}
