/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.authorization.api.provider.config;

import com.elitesland.cloudt.authorization.api.client.config.AuthorizationProperties;
import com.elitesland.cloudt.authorization.api.provider.AuthenticationService;
import com.elitesland.cloudt.authorization.api.provider.config.SystemConfig;
import com.elitesland.cloudt.authorization.api.provider.config.servlet.ServletOAuth2ClientConfig;
import com.elitesland.cloudt.authorization.api.provider.config.servlet.ServletOAuth2ServerConfig;
import com.elitesland.cloudt.authorization.api.provider.config.servlet.ServletSingleConfig;
import com.elitesland.cloudt.authorization.api.provider.config.system.ConfigProperties;
import com.elitesland.cloudt.authorization.api.provider.security.AuthenticationCheckService;
import com.elitesland.cloudt.authorization.api.provider.security.impl.DefaultAuthenticationCheckServiceImpl;
import com.elitesland.cloudt.authorization.api.provider.web.controller.LoginSupportController;
import com.elitesland.yst.security.entity.GeneralUserDetails;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.oauth2.jwt.JwtClaimsSet;
import org.springframework.security.oauth2.server.authorization.token.JwtEncodingContext;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenCustomizer;
import org.springframework.util.Assert;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(prefix="elitesland.authorization", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableWebSecurity(debug=true)
@Import(value={ServletSingleConfig.class, ServletOAuth2ServerConfig.class, ServletOAuth2ClientConfig.class, SystemConfig.class})
public class AuthorizationAutoConfiguration {
    private static final Logger log = LogManager.getLogger(AuthorizationAutoConfiguration.class);
    private final AuthorizationProperties authorizationProperties;

    public AuthorizationAutoConfiguration(AuthorizationProperties authorizationProperties) {
        this.authorizationProperties = authorizationProperties;
        Assert.notNull((Object)authorizationProperties.getType(), (String)"\u672a\u77e5\u670d\u52a1\u8ba4\u8bc1\u65b9\u5f0f");
        log.info("\u670d\u52a1\u8ba4\u8bc1\u65b9\u5f0f\uff1a{}", (Object)authorizationProperties.getType());
    }

    @Bean
    public OAuth2TokenCustomizer<JwtEncodingContext> jwtCustomizer() {
        return context -> {
            Object principal = context.getPrincipal().getPrincipal();
            if (principal instanceof GeneralUserDetails) {
                GeneralUserDetails userDetails = (GeneralUserDetails)principal;
                JwtClaimsSet.Builder claims = context.getClaims();
                claims.claim("yst_un", (Object)userDetails.getUsername());
                claims.claim("yst_ui", (Object)userDetails.getUser().getId());
                if (userDetails.getTenant() != null) {
                    claims.claim("yst_ti", (Object)userDetails.getTenant().getId());
                }
            }
        };
    }

    @Bean
    @ConditionalOnMissingBean
    public AuthenticationService authenticationService() {
        log.warn("\u672a\u5b9e\u73b0\u8ba4\u8bc1\u670d\u52a1\u63a5\u53e3");
        return () -> null;
    }

    @Bean
    @ConditionalOnBean(value={AuthenticationService.class})
    public LoginSupportController loginSupportController(AuthenticationService authenticationService) {
        return new LoginSupportController(authenticationService);
    }

    @Bean
    public AuthenticationCheckService defaultAuthenticationCheckService(ConfigProperties configProperties) {
        return new DefaultAuthenticationCheckServiceImpl(configProperties);
    }
}

