/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.authorization.api.provider.config;

import com.elitesland.cloudt.authorization.api.client.config.AuthorizationProperties;
import com.elitesland.cloudt.authorization.api.client.tool.RedisHelper;
import com.elitesland.cloudt.authorization.api.provider.config.system.ConfigProperties;
import com.elitesland.cloudt.authorization.api.provider.config.system.WechatProperties;
import com.elitesland.cloudt.authorization.api.provider.provider.CaptchaProvider;
import com.elitesland.cloudt.authorization.api.provider.provider.LoginSupportProvider;
import com.elitesland.cloudt.authorization.api.provider.provider.rmi.messenger.RmiMsgCarrierDubboService;
import com.elitesland.cloudt.authorization.api.provider.provider.rmi.support.RmiOrgUserEmpBuRpcService;
import com.elitesland.cloudt.authorization.api.provider.provider.rmi.system.RmiSysUserRpcService;
import com.elitesland.cloudt.authorization.api.provider.provider.sms.SmsCodeProvider;
import com.elitesland.cloudt.authorization.api.provider.provider.user.UserDetailManager;
import com.elitesland.cloudt.authorization.api.provider.provider.wechat.WechatAppletService;
import com.elitesland.cloudt.authorization.api.provider.provider.wechat.provider.WechatAppletServiceImpl;
import com.elitesland.cloudt.authorization.api.provider.web.controller.CommonLoginSupportController;
import org.apache.dubbo.config.bootstrap.DubboBootstrap;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

@Import(value={ConfigOnDubbo.class})
public class LoginSupportConfig {
    private final AuthorizationProperties authorizationProperties;
    private final ConfigProperties configProperties;

    public LoginSupportConfig(AuthorizationProperties authorizationProperties, ConfigProperties configProperties) {
        this.authorizationProperties = authorizationProperties;
        this.configProperties = configProperties;
    }

    @Bean
    public LoginSupportProvider loginSupportProvider() {
        return new LoginSupportProvider(this.configProperties);
    }

    @Bean
    public CommonLoginSupportController commonLoginSupportController(LoginSupportProvider loginSupportProvider) {
        return new CommonLoginSupportController(loginSupportProvider);
    }

    @ConditionalOnBean(value={RmiSysUserRpcService.class})
    @Bean
    public UserDetailManager userDetailManager(RmiSysUserRpcService rmiSysUserRpcService) {
        return new UserDetailManager(this.authorizationProperties, this.configProperties, rmiSysUserRpcService);
    }

    @ConditionalOnBean(value={RedisHelper.class, RmiMsgCarrierDubboService.class})
    @Bean
    public SmsCodeProvider smsCodeProvider(RedisHelper redisHelper, RmiMsgCarrierDubboService rmiMsgCarrierDubboService) {
        return new SmsCodeProvider(redisHelper, this.configProperties, rmiMsgCarrierDubboService);
    }

    @ConditionalOnBean(value={RedisHelper.class})
    @Bean
    public CaptchaProvider captchaProvider(RedisHelper redisHelper) {
        return new CaptchaProvider(redisHelper);
    }

    @ConditionalOnBean(value={RmiSysUserRpcService.class})
    @Bean
    public WechatAppletService wechatAppletService(RmiSysUserRpcService rmiSysUserRpcService, WechatProperties wechatProperties) {
        return new WechatAppletServiceImpl(rmiSysUserRpcService, wechatProperties);
    }

    @ConditionalOnClass(value={DubboBootstrap.class})
    static class ConfigOnDubbo {
        ConfigOnDubbo() {
        }

        @Bean
        public RmiMsgCarrierDubboService rmiMsgCarrierDubboService() {
            return new RmiMsgCarrierDubboService();
        }

        @Bean
        public RmiOrgUserEmpBuRpcService rmiOrgUserEmpBuRpcService() {
            return new RmiOrgUserEmpBuRpcService();
        }

        @Bean
        public RmiSysUserRpcService rmiSysUserRpcService() {
            return new RmiSysUserRpcService();
        }
    }
}

