/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.authorization.api.provider.config;

import com.elitesland.boot.autoconfigure.elasticsearch.annotation.EnableElasticsearch;
import com.elitesland.boot.autoconfigure.elasticsearch.config.ElasticsearchConfiguration;
import com.elitesland.cloudt.authorization.api.provider.config.system.ConfigProperties;
import com.elitesland.cloudt.authorization.api.provider.config.system.TenantProperties;
import com.elitesland.cloudt.authorization.api.provider.config.system.WechatProperties;
import com.elitesland.cloudt.authorization.api.provider.security.AuthenticationCheckService;
import com.elitesland.cloudt.authorization.api.provider.security.impl.TenantAuthenticationCheckServiceImpl;
import com.elitesland.cloudt.tenant.TenantClient;
import com.elitesland.yst.core.config.datasource.hibernate.QueryDSLConfig;
import com.elitesland.yst.core.provider.tenant.TenantClientProvider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.scheduling.annotation.EnableScheduling;

@EnableConfigurationProperties(value={ConfigProperties.class, WechatProperties.class, TenantProperties.class})
@Import(value={JpaConfig.class, ElasticsearchConfig.class})
@EnableScheduling
@EnableCaching
public class SystemConfig {
    private static final Logger log = LogManager.getLogger(SystemConfig.class);

    @ConditionalOnClass(value={QueryDSLConfig.class})
    @Import(value={QueryDSLConfig.class})
    static class JpaConfig {
        JpaConfig() {
        }
    }

    @ConditionalOnClass(value={ElasticsearchConfiguration.class})
    @EnableElasticsearch(basePackages={"com.elitesland.cloudt.authorization"})
    static class ElasticsearchConfig {
        ElasticsearchConfig() {
        }
    }

    @ConditionalOnClass(value={TenantClient.class})
    static class TenantConfig {
        TenantConfig() {
        }

        @Bean
        public AuthenticationCheckService tenantAuthenticationCheckService(TenantProperties tenantProperties, TenantClientProvider tenantClientProvider) {
            return new TenantAuthenticationCheckServiceImpl(tenantProperties, tenantClientProvider);
        }
    }
}

