/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.authorization.api.provider.config.servlet;

import com.elitesland.cloudt.authorization.api.client.config.AuthorizationProperties;
import com.elitesland.cloudt.authorization.api.provider.provider.oauth2.client.OAuth2ClientProvider;
import com.elitesland.cloudt.authorization.api.provider.web.controller.OAuth2LoginSupportController;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;

@ConditionalOnProperty(prefix="elitesland.authorization.oauth2-client", name={"client-id"})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class ServletOAuth2ClientConfig {
    private static final Logger log = LogManager.getLogger(ServletOAuth2ClientConfig.class);
    private final AuthorizationProperties authorizationProperties;

    public ServletOAuth2ClientConfig(AuthorizationProperties authorizationProperties) {
        this.authorizationProperties = authorizationProperties;
    }

    @Bean
    public OAuth2ClientProvider oAuth2ClientProvider() {
        return new OAuth2ClientProvider(this.authorizationProperties);
    }

    @Bean
    public OAuth2LoginSupportController oAuth2SettingController(OAuth2ClientProvider oAuth2ClientProvider) {
        return new OAuth2LoginSupportController(oAuth2ClientProvider);
    }
}

