/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.authorization.api.provider.config.servlet;

import com.elitesland.cloudt.authorization.api.client.config.AuthorizationProperties;
import com.elitesland.cloudt.authorization.api.client.config.security.AbstractServletSecurityConfig;
import com.elitesland.cloudt.authorization.api.client.config.security.handler.DefaultAccessDeniedHandler;
import com.elitesland.cloudt.authorization.api.client.config.security.handler.DefaultAuthenticationEntryPointHandler;
import com.elitesland.cloudt.authorization.api.client.config.security.handler.DefaultAuthenticationFailureHandler;
import com.elitesland.cloudt.authorization.api.client.tool.RedisHelper;
import com.elitesland.cloudt.authorization.api.client.util.JwtUtil;
import com.elitesland.cloudt.authorization.api.provider.config.LoginSupportConfig;
import com.elitesland.cloudt.authorization.api.provider.security.configurer.OAuth2AuthorizationCodeStateFilterSecurityConfigurer;
import com.elitesland.cloudt.authorization.api.provider.security.handler.oauth2.server.OAuth2ServerAuthenticationEntryPointHandler;
import com.elitesland.cloudt.authorization.api.provider.security.handler.oauth2.server.OAuth2ServerAuthenticationSuccessHandler;
import com.elitesland.cloudt.authorization.api.provider.security.handler.oauth2.server.OAuth2ServerErrorResponseHandler;
import com.elitesland.cloudt.authorization.api.provider.security.handler.oauth2.server.support.OAuth2AuthorizationCodeRequestCache;
import com.elitesland.cloudt.authorization.api.provider.security.impl.RedisOAuth2AuthorizationCodeRequestCache;
import com.elitesland.cloudt.authorization.api.provider.service.impl.JpaOAuth2AuthorizationConsentService;
import com.elitesland.cloudt.authorization.api.provider.service.impl.JpaOAuth2AuthorizationService;
import com.elitesland.cloudt.authorization.api.provider.service.impl.JpaRegisteredClientRepository;
import com.elitesland.cloudt.authorization.api.provider.service.reposotory.OAuth2AuthenticationRepo;
import com.elitesland.cloudt.authorization.api.provider.service.reposotory.OAuth2AuthenticationRepoProc;
import com.elitesland.cloudt.authorization.api.provider.service.reposotory.OAuth2AuthorizationConsentRepo;
import com.elitesland.cloudt.authorization.api.provider.service.reposotory.OAuth2AuthorizationConsentRepoProc;
import com.elitesland.cloudt.authorization.api.provider.service.reposotory.OAuth2RegisteredClientRepo;
import com.elitesland.cloudt.authorization.api.provider.service.reposotory.OAuth2RegisteredClientRepoProc;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.SecurityContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization.OAuth2AuthorizationServerConfigurer;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationConsentService;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.security.oauth2.server.authorization.config.ProviderSettings;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestHeaderRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@ConditionalOnProperty(prefix="elitesland.authorization", name={"type"}, havingValue="oauth2_server")
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@Import(value={LoginSupportConfig.class})
public class ServletOAuth2ServerConfig
extends AbstractServletSecurityConfig {
    private static final Logger log = LogManager.getLogger(ServletOAuth2ServerConfig.class);
    @Value(value="${spring.security.oauth2.resourceserver.jwt.issuer-uri:#{null}}")
    private String issuerUri;
    private final OAuth2AuthorizationCodeRequestCache oAuth2AuthorizationCodeRequestCache;

    public ServletOAuth2ServerConfig(AuthorizationProperties authorizationProperties, OAuth2AuthorizationCodeRequestCache oAuth2AuthorizationCodeRequestCache) {
        super(authorizationProperties);
        this.oAuth2AuthorizationCodeRequestCache = oAuth2AuthorizationCodeRequestCache;
    }

    @Bean(value={"authorizationServerSecurityFilterChain"})
    @Order(value=-2147483648)
    @ConditionalOnMissingBean(name={"authorizationServerSecurityFilterChain"})
    public SecurityFilterChain authorizationServerSecurityFilterChain(HttpSecurity http, ProviderSettings providerSettings, RegisteredClientRepository clientRepository, OAuth2AuthorizationService oAuth2AuthorizationService) throws Exception {
        OAuth2ServerAuthenticationSuccessHandler authenticationSuccessHandler = new OAuth2ServerAuthenticationSuccessHandler(this.oAuth2AuthorizationCodeRequestCache, clientRepository, oAuth2AuthorizationService);
        DefaultAuthenticationFailureHandler authenticationFailureHandler = new DefaultAuthenticationFailureHandler();
        OAuth2ServerAuthenticationEntryPointHandler entryPointHandler = new OAuth2ServerAuthenticationEntryPointHandler(this.oAuth2AuthorizationCodeRequestCache, providerSettings.getAuthorizationEndpoint());
        DefaultAccessDeniedHandler accessDeniedHandler = new DefaultAccessDeniedHandler();
        OAuth2AuthorizationServerConfigurer authorizationServerConfigurer = new OAuth2AuthorizationServerConfigurer();
        RequestMatcher endpointsMatcher = authorizationServerConfigurer.getEndpointsMatcher();
        authorizationServerConfigurer.authorizationEndpoint(configurer -> configurer.errorResponseHandler((AuthenticationFailureHandler)new OAuth2ServerErrorResponseHandler()).authorizationResponseHandler((AuthenticationSuccessHandler)authenticationSuccessHandler)).clientAuthentication(configurer -> configurer.errorResponseHandler((AuthenticationFailureHandler)authenticationFailureHandler)).tokenEndpoint(configurer -> configurer.errorResponseHandler((AuthenticationFailureHandler)authenticationFailureHandler).accessTokenResponseHandler((AuthenticationSuccessHandler)authenticationSuccessHandler));
        ((HttpSecurity)((OAuth2AuthorizationCodeStateFilterSecurityConfigurer)((HttpSecurity)((OAuth2AuthorizationServerConfigurer)http.requestMatcher(endpointsMatcher).authorizeRequests(req -> ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)req.anyRequest()).authenticated()).apply((SecurityConfigurerAdapter)authorizationServerConfigurer)).and()).apply(new OAuth2AuthorizationCodeStateFilterSecurityConfigurer())).and()).exceptionHandling(configurer -> {
            if (StringUtils.hasText((String)this.authorizationProperties.getLoginPage())) {
                configurer.defaultAuthenticationEntryPointFor((AuthenticationEntryPoint)entryPointHandler, (RequestMatcher)new RequestHeaderRequestMatcher("X-Auth-Redirect", "false")).defaultAuthenticationEntryPointFor((AuthenticationEntryPoint)new LoginUrlAuthenticationEntryPoint(this.authorizationProperties.getLoginPage()), (RequestMatcher)new AntPathRequestMatcher("/**"));
            } else {
                configurer.authenticationEntryPoint((AuthenticationEntryPoint)entryPointHandler);
            }
            configurer.accessDeniedHandler((AccessDeniedHandler)accessDeniedHandler);
        });
        if (Boolean.FALSE.equals(this.authorizationProperties.getCsrfEnabled())) {
            http.csrf().disable();
        } else {
            http.csrf().ignoringRequestMatchers(new RequestMatcher[]{endpointsMatcher});
        }
        this.corsConfiguration(http);
        return (SecurityFilterChain)http.build();
    }

    @Bean(value={"defaultSecurityFilterChain"})
    @ConditionalOnMissingBean(name={"defaultSecurityFilterChain"})
    public SecurityFilterChain defaultSecurityFilterChain(HttpSecurity http) throws Exception {
        this.defaultSecurityConfig(http);
        http.oauth2ResourceServer(config -> config.jwt().and().authenticationEntryPoint((AuthenticationEntryPoint)new DefaultAuthenticationEntryPointHandler(this.authorizationProperties.getLoginPage())));
        return (SecurityFilterChain)http.build();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={RedisHelper.class})
    public OAuth2AuthorizationCodeRequestCache oAuth2AuthorizationCodeRequestCache(RedisHelper redisHelper) {
        return new RedisOAuth2AuthorizationCodeRequestCache(redisHelper);
    }

    @Bean
    public JWKSource<SecurityContext> jwkSource(RSAKey rsaKey) {
        return JwtUtil.generateJwkSource((RSAKey)rsaKey);
    }

    @Bean
    public ProviderSettings providerSettings() {
        Assert.hasText((String)this.issuerUri, (String)"spring.security.oauth2.resourceserver.jwt.issuer-uri\u4e0d\u53ef\u4e3a\u7a7a");
        return ProviderSettings.builder().issuer(this.issuerUri).build();
    }

    @ConditionalOnClass(value={JpaRepository.class})
    static class ConfigOnJpa {
        ConfigOnJpa() {
        }

        @Bean
        @ConditionalOnMissingBean
        public RegisteredClientRepository registeredClientRepository(OAuth2RegisteredClientRepo oAuth2RegisteredClientRepo, OAuth2RegisteredClientRepoProc oAuth2RegisteredClientRepoProc) {
            return new JpaRegisteredClientRepository(oAuth2RegisteredClientRepo, oAuth2RegisteredClientRepoProc);
        }

        @Bean
        @ConditionalOnMissingBean
        public OAuth2AuthorizationService authorizationService(RegisteredClientRepository registeredClientRepository, OAuth2AuthenticationRepo oAuth2AuthenticationRepo, OAuth2AuthenticationRepoProc oAuth2AuthenticationRepoProc) {
            return new JpaOAuth2AuthorizationService(registeredClientRepository, oAuth2AuthenticationRepo, oAuth2AuthenticationRepoProc);
        }

        @Bean
        @ConditionalOnMissingBean
        public OAuth2AuthorizationConsentService authorizationConsentService(RegisteredClientRepository registeredClientRepository, OAuth2AuthorizationConsentRepo oAuth2AuthorizationConsentRepo, OAuth2AuthorizationConsentRepoProc oAuth2AuthorizationConsentRepoProc) {
            return new JpaOAuth2AuthorizationConsentService(registeredClientRepository, oAuth2AuthorizationConsentRepo, oAuth2AuthorizationConsentRepoProc);
        }
    }
}

