/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.authorization.api.provider.config.servlet;

import com.elitesland.cloudt.authorization.api.client.config.AuthorizationProperties;
import com.elitesland.cloudt.authorization.api.client.config.security.AbstractServletSecurityConfig;
import com.elitesland.cloudt.authorization.api.client.config.security.handler.DefaultAuthenticationFailureHandler;
import com.elitesland.cloudt.authorization.api.client.config.support.AuthenticationCache;
import com.elitesland.cloudt.authorization.api.client.util.JwtUtil;
import com.elitesland.cloudt.authorization.api.provider.config.LoginSupportConfig;
import com.elitesland.cloudt.authorization.api.provider.security.configurer.LoginFilterSecurityConfigurer;
import com.elitesland.cloudt.authorization.api.provider.security.configurer.support.LoginFilterCustomizer;
import com.elitesland.cloudt.authorization.api.provider.security.handler.JwtAuthenticationSuccessHandler;
import com.nimbusds.jose.jwk.RSAKey;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.oauth2.server.authorization.token.JwtEncodingContext;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenCustomizer;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;

@ConditionalOnProperty(prefix="elitesland.authorization", name={"type"}, havingValue="single")
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@Import(value={LoginSupportConfig.class})
public class ServletSingleConfig
extends AbstractServletSecurityConfig {
    private static final Logger log = LogManager.getLogger(ServletSingleConfig.class);
    private final RSAKey rsaKey;
    private ObjectProvider<OAuth2TokenCustomizer<JwtEncodingContext>> tokenCustomizerObjectProvider;
    private ObjectProvider<LoginFilterCustomizer<HttpSecurity>> loginFilterCustomizers;

    public ServletSingleConfig(AuthorizationProperties authorizationProperties, RSAKey rsaKey) {
        super(authorizationProperties);
        this.rsaKey = rsaKey;
    }

    @Bean(value={"defaultSecurityFilterChain"})
    @ConditionalOnMissingBean(name={"defaultSecurityFilterChain"})
    public SecurityFilterChain defaultSecurityFilterChain(HttpSecurity http) throws Exception {
        JwtAuthenticationSuccessHandler successHandler = new JwtAuthenticationSuccessHandler(this.authorizationProperties, (AuthenticationCache)this.cacheObjectProvider.getIfAvailable(), JwtUtil.buildJwtEncoder((RSAKey)this.rsaKey));
        OAuth2TokenCustomizer tokenCustomizer = (OAuth2TokenCustomizer)this.tokenCustomizerObjectProvider.getIfAvailable();
        successHandler.setTokenCustomizer((OAuth2TokenCustomizer<JwtEncodingContext>)tokenCustomizer);
        ((LoginFilterSecurityConfigurer)((Object)((LoginFilterSecurityConfigurer)super.defaultSecurityConfig(http).apply(new LoginFilterSecurityConfigurer<HttpSecurity>(this.loginFilterCustomizers))).successHandler((AuthenticationSuccessHandler)successHandler))).failureHandler((AuthenticationFailureHandler)new DefaultAuthenticationFailureHandler());
        return (SecurityFilterChain)http.build();
    }

    @Autowired
    public void setTokenCustomizerObjectProvider(ObjectProvider<OAuth2TokenCustomizer<JwtEncodingContext>> tokenCustomizerObjectProvider) {
        this.tokenCustomizerObjectProvider = tokenCustomizerObjectProvider;
    }

    @Autowired
    public void setLoginFilterCustomizers(ObjectProvider<LoginFilterCustomizer<HttpSecurity>> loginFilterCustomizers) {
        this.loginFilterCustomizers = loginFilterCustomizers;
    }
}

