/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.authorization.api.provider.provider;

import cn.hutool.captcha.AbstractCaptcha;
import cn.hutool.core.util.PhoneUtil;
import com.elitesland.cloudt.authorization.api.provider.config.system.CaptchaEnum;
import com.elitesland.cloudt.authorization.api.provider.config.system.CaptchaInfo;
import com.elitesland.cloudt.authorization.api.provider.config.system.ConfigProperties;
import com.elitesland.cloudt.authorization.api.provider.config.system.LoginProperties;
import com.elitesland.cloudt.authorization.api.provider.config.system.SmsCodeEnum;
import com.elitesland.cloudt.authorization.api.provider.model.vo.resp.CaptchaRespVO;
import com.elitesland.cloudt.authorization.api.provider.provider.CaptchaProvider;
import com.elitesland.cloudt.authorization.api.provider.provider.sms.SmsCodeProvider;
import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.common.exception.BusinessException;
import java.time.Duration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class LoginSupportProvider {
    private static final Logger log = LogManager.getLogger(LoginSupportProvider.class);
    private final ConfigProperties configProperties;
    private CaptchaProvider captchaManager;
    private SmsCodeProvider smsCodeManager;

    public LoginSupportProvider(ConfigProperties configProperties) {
        this.configProperties = configProperties;
    }

    public ApiResult<CaptchaRespVO> generateCaptcha() {
        LoginProperties loginProperties = this.configProperties.getLogin();
        CaptchaInfo captchaInfo = loginProperties.getCaptchaInfo();
        CaptchaRespVO respVO = null;
        Duration timeToLive = Duration.ofMinutes(captchaInfo.getExpiration());
        AbstractCaptcha captchaHu = loginProperties.getCaptchaHu();
        respVO = captchaHu != null ? this.getCaptchaManager().generateCaptchaHu(CaptchaEnum.LOGIN, captchaHu, timeToLive) : this.getCaptchaManager().generateCaptcha(CaptchaEnum.LOGIN, loginProperties.getCaptcha(), timeToLive);
        return ApiResult.ok((Object)respVO);
    }

    public ApiResult<Boolean> verifyCaptcha(String captchaKey, String captchaText) {
        if (!StringUtils.hasText((String)captchaKey)) {
            return ApiResult.fail((String)"\u672a\u8bbe\u7f6e\u9a8c\u8bc1\u7801");
        }
        if (!StringUtils.hasText((String)captchaText)) {
            return ApiResult.fail((String)"\u9a8c\u8bc1\u7801\u4e3a\u7a7a");
        }
        boolean verify = this.getCaptchaManager().verifyCaptcha(CaptchaEnum.LOGIN, captchaKey, captchaText);
        return ApiResult.ok((Object)verify);
    }

    public ApiResult<String> sendSmsCode(String mobile) {
        if (!StringUtils.hasText((String)mobile)) {
            return ApiResult.fail((String)"\u624b\u673a\u53f7\u4e3a\u7a7a");
        }
        if (!PhoneUtil.isMobile((CharSequence)mobile)) {
            return ApiResult.fail((String)"\u624b\u673a\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        String code = this.getSmsCodeManager().send(SmsCodeEnum.LOGIN, mobile, null, null);
        Object msg = code == null ? "\u53d1\u9001\u6210\u529f" : "\u6a21\u62df\u6d4b\u8bd5\u77ed\u4fe1\u9a8c\u8bc1\u7801\uff0c\u9a8c\u8bc1\u7801\u662f" + code;
        return ApiResult.ok((Object)msg);
    }

    public CaptchaProvider getCaptchaManager() {
        if (this.captchaManager == null) {
            throw new BusinessException("\u9a8c\u8bc1\u7801\u670d\u52a1\u672a\u521d\u59cb\u5316");
        }
        return this.captchaManager;
    }

    @Autowired(required=false)
    public void setCaptchaManager(CaptchaProvider captchaManager) {
        this.captchaManager = captchaManager;
    }

    public SmsCodeProvider getSmsCodeManager() {
        if (this.smsCodeManager == null) {
            throw new BusinessException("\u77ed\u4fe1\u670d\u52a1\u672a\u521d\u59cb\u5316");
        }
        return this.smsCodeManager;
    }

    @Autowired(required=false)
    public void setSmsCodeManager(SmsCodeProvider smsCodeManager) {
        this.smsCodeManager = smsCodeManager;
    }
}

