/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.authorization.api.provider.provider.oauth2.client;

import com.elitesland.cloudt.authorization.api.client.config.AuthorizationProperties;
import com.elitesland.cloudt.authorization.api.client.model.OAuthToken;
import com.elitesland.cloudt.authorization.api.provider.model.bo.OAuth2ClientConfigBO;
import com.elitesland.yst.common.base.ApiResult;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.lang.NonNull;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public class OAuth2ClientProvider
implements ApplicationRunner {
    private static final Logger log = LogManager.getLogger(OAuth2ClientProvider.class);
    private final AuthorizationProperties authorizationProperties;
    private OAuth2ClientConfigBO oAuth2ClientConfigBO;
    private RestTemplate restTemplate;

    public OAuth2ClientProvider(AuthorizationProperties authorizationProperties) {
        this.authorizationProperties = authorizationProperties;
    }

    public void run(ApplicationArguments args) throws Exception {
        this.initConfig();
    }

    public OAuth2ClientConfigBO getoAuth2ClientConfigBO() {
        return this.oAuth2ClientConfigBO.copy();
    }

    public ApiResult<OAuthToken> code2AccessToken(@NonNull String clientId, @NonNull String code, @NonNull String redirectUri, String codeVerifier) {
        OAuth2ClientConfigBO clientConfig = this.getoAuth2ClientConfigBO();
        LinkedMultiValueMap postParam = new LinkedMultiValueMap(8);
        postParam.add((Object)"client_id", (Object)clientConfig.getClientId());
        postParam.add((Object)"client_secret", (Object)clientConfig.getClientSecret());
        postParam.add((Object)"grant_type", (Object)AuthorizationGrantType.AUTHORIZATION_CODE.getValue());
        postParam.add((Object)"code", (Object)code);
        postParam.add((Object)"redirect_uri", (Object)redirectUri);
        if (StringUtils.hasText((String)codeVerifier)) {
            postParam.add((Object)"code_verifier", (Object)codeVerifier);
        }
        try {
            ResponseEntity resp = this.restTemplate.exchange("/oauth2/token", HttpMethod.POST, new HttpEntity((Object)postParam), (ParameterizedTypeReference)new ParameterizedTypeReference<ApiResult<OAuthToken>>(){}, new Object[0]);
            if (resp.getStatusCode().is2xxSuccessful()) {
                return (ApiResult)resp.getBody();
            }
            log.error("\u6388\u6743\u7801\u8f6ctoken\u5931\u8d25\uff1a{}", (Object)resp.getStatusCode());
            return ApiResult.fail((String)"\u83b7\u53d6\u8ba4\u8bc1token\u5931\u8d25");
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u8ba4\u8bc1token\u5931\u8d25\uff1a", (Throwable)e);
            return ApiResult.fail((String)"\u83b7\u53d6\u8ba4\u8bc1token\u5931\u8d25\uff01");
        }
    }

    private void initConfig() {
        AuthorizationProperties.OAuth2Client client = this.authorizationProperties.getOauth2Client();
        Assert.hasText((String)client.getClientId(), (String)"\u5ba2\u6237\u7aefID\u4e3a\u7a7a");
        Assert.hasText((String)client.getClientSecret(), (String)"\u5ba2\u6237\u7aefsecret\u4e3a\u7a7a");
        Assert.hasText((String)client.getServerAddress(), (String)"OAuth2\u670d\u52a1\u7aef\u5730\u5740\u4e3a\u7a7a");
        this.restTemplate = this.buildRestTemplate();
        OAuth2ClientConfigBO configBO = new OAuth2ClientConfigBO();
        configBO.setClientId(client.getClientId());
        configBO.setClientSecret(client.getClientSecret());
        Map<String, Object> serverConfig = null;
        if (StringUtils.hasText((String)client.getAuthorizeEndpoint())) {
            configBO.setAuthorizeEndpoint(client.getAuthorizeEndpoint());
        } else {
            if (serverConfig == null) {
                serverConfig = this.queryServerConfig();
            }
            String authorizeEndpoint = (String)serverConfig.get("authorization_endpoint");
            Assert.hasText((String)authorizeEndpoint, (String)"OAuth2\u5ba2\u6237\u7aef\u7684authorizeEndpoint\u672a\u914d\u7f6e");
            configBO.setAuthorizeEndpoint(authorizeEndpoint);
        }
        if (StringUtils.hasText((String)client.getTokenEndpoint())) {
            configBO.setTokenEndpoint(client.getTokenEndpoint());
        } else {
            if (serverConfig == null) {
                serverConfig = this.queryServerConfig();
            }
            String tokenEndpoint = (String)serverConfig.get("token_endpoint");
            Assert.hasText((String)tokenEndpoint, (String)"OAuth2\u5ba2\u6237\u7aef\u7684tokenEndpoint\u672a\u914d\u7f6e");
            configBO.setTokenEndpoint(tokenEndpoint);
        }
        this.oAuth2ClientConfigBO = configBO;
    }

    private RestTemplate buildRestTemplate() {
        return new RestTemplateBuilder(new RestTemplateCustomizer[0]).requestFactory(this::getClientHttpRequestFactory).rootUri(this.authorizationProperties.getOauth2Client().getServerAddress()).customizers(new RestTemplateCustomizer[]{this.restTemplateCustomizer()}).build();
    }

    private RestTemplateCustomizer restTemplateCustomizer() {
        ObjectMapper objectMapper = new ObjectMapper();
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        javaTimeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        javaTimeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        javaTimeModule.addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        javaTimeModule.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        objectMapper.registerModule((Module)javaTimeModule);
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        return template -> {
            for (HttpMessageConverter convert : template.getMessageConverters()) {
                if (!(convert instanceof MappingJackson2HttpMessageConverter)) continue;
                ((MappingJackson2HttpMessageConverter)convert).setObjectMapper(objectMapper);
                return;
            }
            template.getMessageConverters().add(new MappingJackson2HttpMessageConverter(objectMapper));
        };
    }

    private ClientHttpRequestFactory getClientHttpRequestFactory() {
        SSLConnectionSocketFactory sslConnectionSocketFactory = null;
        try {
            SSLContextBuilder sslContextBuilder = new SSLContextBuilder();
            sslContextBuilder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
            sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContextBuilder.build(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        httpClientBuilder.setSSLSocketFactory(sslConnectionSocketFactory);
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory();
        requestFactory.setHttpClient((HttpClient)httpClientBuilder.build());
        requestFactory.setConnectTimeout((int)Duration.ofSeconds(10L).toMillis());
        requestFactory.setReadTimeout((int)Duration.ofSeconds(30L).toMillis());
        return requestFactory;
    }

    private Map<String, Object> queryServerConfig() {
        try {
            ResponseEntity resp = this.restTemplate.exchange("/.well-known/oauth-authorization-server", HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<Map<String, Object>>(){}, new Object[0]);
            if (resp.getStatusCode().is2xxSuccessful()) {
                log.info("\u67e5\u8be2OAuth2\u670d\u52a1\u7aef\u914d\u7f6e\u6210\u529f\uff1a{}", resp.getBody());
                return (Map)resp.getBody();
            }
            log.warn("\u67e5\u8be2OAuth2\u670d\u52a1\u7aef\u914d\u7f6e\u5931\u8d25\uff1a{}", (Object)resp.getStatusCode());
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2OAuth2\u670d\u52a1\u7aef\u914d\u7f6e\u5f02\u5e38", (Throwable)e);
        }
        return Collections.emptyMap();
    }
}

