/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.authorization.api.provider.provider.user;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.BooleanUtil;
import com.elitesland.cloudt.authorization.api.client.common.AuthorizationException;
import com.elitesland.cloudt.authorization.api.client.config.AuthorizationProperties;
import com.elitesland.cloudt.authorization.api.provider.config.system.ConfigProperties;
import com.elitesland.cloudt.authorization.api.provider.provider.rmi.support.RmiOrgUserEmpBuRpcService;
import com.elitesland.cloudt.authorization.api.provider.provider.rmi.system.RmiSysUserRpcService;
import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.security.dto.SecurityOrgUserEmpBuDTO;
import com.elitesland.yst.security.entity.GeneralUserDetails;
import com.elitesland.yst.supportdomain.provider.org.dto.OrgUserEmpBuDTO;
import com.elitesland.yst.system.vo.SysRoleVO;
import com.elitesland.yst.system.vo.SysUserDTO;
import java.util.Collection;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class UserDetailManager {
    private static final Logger log = LogManager.getLogger(UserDetailManager.class);
    private final AuthorizationProperties authorizationProperties;
    private final ConfigProperties configProperties;
    private final RmiSysUserRpcService rmiSysUserRpcService;
    private RmiOrgUserEmpBuRpcService rmiOrgUserEmpBuRpcService;

    public UserDetailManager(AuthorizationProperties authorizationProperties, ConfigProperties configProperties, RmiSysUserRpcService rmiSysUserRpcService) {
        this.authorizationProperties = authorizationProperties;
        this.configProperties = configProperties;
        this.rmiSysUserRpcService = rmiSysUserRpcService;
    }

    public GeneralUserDetails loadUserByUsername(String username) {
        return this.loadUser(() -> (SysUserDTO)this.rmiSysUserRpcService.getUserByUsername(username).getData(), "\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef");
    }

    public GeneralUserDetails loadUserByMobile(String mobile) {
        return this.loadUser(() -> (SysUserDTO)this.rmiSysUserRpcService.getUserByMobile(mobile).getData(), "\u624b\u673a\u53f7\u6216\u5bc6\u7801\u9519\u8bef");
    }

    public GeneralUserDetails loadUserByEmail(String email) {
        return this.loadUser(() -> (SysUserDTO)this.rmiSysUserRpcService.getUserByEmail(email).getData(), "\u90ae\u7bb1\u6216\u5bc6\u7801\u9519\u8bef");
    }

    public GeneralUserDetails loadUserByAccount(String account) {
        return this.loadUser(() -> (SysUserDTO)this.rmiSysUserRpcService.getUserByAccount(account).getData(), "\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef");
    }

    public GeneralUserDetails loadUserByWechatOpenid(String wechatOpenid) {
        SysUserDTO user = (SysUserDTO)this.rmiSysUserRpcService.getUserByWechatOpenid(wechatOpenid).getData();
        if (user == null) {
            throw new AuthorizationException("\u5fae\u4fe1\u53f7\u6682\u672a\u7ed1\u5b9a\u7528\u6237");
        }
        this.checkSysUserStatus(user);
        SecurityOrgUserEmpBuDTO empBu = this.findUserEmpBuInfo(user.getId());
        return this.wrapUserDetail(user, empBu);
    }

    @Autowired(required=false)
    public void setRmiOrgUserEmpBuRpcService(RmiOrgUserEmpBuRpcService rmiOrgUserEmpBuRpcService) {
        this.rmiOrgUserEmpBuRpcService = rmiOrgUserEmpBuRpcService;
    }

    private GeneralUserDetails loadUser(Supplier<SysUserDTO> userDTOSupplier, String userNotExistsTip) {
        SysUserDTO user = userDTOSupplier.get();
        if (user == null) {
            throw new UsernameNotFoundException(userNotExistsTip);
        }
        this.checkSysUserStatus(user);
        SecurityOrgUserEmpBuDTO empBu = this.findUserEmpBuInfo(user.getId());
        return this.wrapUserDetail(user, empBu);
    }

    private void checkSysUserStatus(SysUserDTO user) {
        if (!BooleanUtil.isTrue((Boolean)user.getEnabled())) {
            throw new DisabledException("\u8d26\u53f7\u5df2\u7981\u7528");
        }
    }

    private GeneralUserDetails wrapUserDetail(SysUserDTO user, SecurityOrgUserEmpBuDTO empBu) {
        if (CollUtil.isNotEmpty((Collection)user.getRoles())) {
            for (SysRoleVO role : user.getRoles()) {
                if (role.getCode() == null || role.getCode().startsWith(this.authorizationProperties.getRolePrefix())) continue;
                role.setCode(this.authorizationProperties.getRolePrefix() + role.getCode());
            }
        }
        return new GeneralUserDetails(user).setSecurityOrgUserEmpBuDTO(empBu);
    }

    private SecurityOrgUserEmpBuDTO findUserEmpBuInfo(Long sysUserId) {
        boolean requiredSupportEmployee = this.configProperties.getLogin().getRequiredSupportEmployee();
        ApiResult<OrgUserEmpBuDTO> queryResult = null;
        try {
            queryResult = this.rmiOrgUserEmpBuRpcService.findUserEmpBuInfoByUserId(sysUserId);
        }
        catch (Exception e) {
            if (requiredSupportEmployee) {
                throw new RuntimeException(e);
            }
            return null;
        }
        if (queryResult == null || !queryResult.isSuccess()) {
            if (requiredSupportEmployee) {
                throw new AuthenticationServiceException("\u67e5\u8be2\u5458\u5de5\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            return null;
        }
        SecurityOrgUserEmpBuDTO empBu = new SecurityOrgUserEmpBuDTO();
        OrgUserEmpBuDTO userEmpBuDTO = (OrgUserEmpBuDTO)queryResult.getData();
        empBu.setUserId(sysUserId);
        if (userEmpBuDTO == null) {
            return empBu;
        }
        empBu.setUserId(userEmpBuDTO.getUserId());
        empBu.setEmpId(userEmpBuDTO.getEmpId());
        empBu.setEmpCodePath(userEmpBuDTO.getEmpCodePath());
        empBu.setChildEmpIds(userEmpBuDTO.getChildEmpIds());
        empBu.setEmpBuTreeId(userEmpBuDTO.getEmpBuTreeId());
        empBu.setEmpBuIds(userEmpBuDTO.getEmpBuIds());
        empBu.setEmpBuCodePath(userEmpBuDTO.getEmpBuCodePath());
        empBu.setChildEmpBuIds(userEmpBuDTO.getChildEmpBuIds());
        empBu.setTopBuCode(userEmpBuDTO.getHeadOuCode());
        empBu.setTopBuName(userEmpBuDTO.getHeadOuName());
        return empBu;
    }
}

