/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.authorization.api.provider.provider.wechat.provider;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.api.impl.WxMaServiceImpl;
import cn.binarywang.wx.miniapp.bean.WxMaJscode2SessionResult;
import cn.binarywang.wx.miniapp.config.WxMaConfig;
import cn.binarywang.wx.miniapp.config.impl.WxMaDefaultConfigImpl;
import com.elitesland.cloudt.authorization.api.provider.config.system.WechatProperties;
import com.elitesland.cloudt.authorization.api.provider.provider.rmi.system.RmiSysUserRpcService;
import com.elitesland.cloudt.authorization.api.provider.provider.wechat.WechatAppletService;
import com.elitesland.cloudt.authorization.api.provider.provider.wechat.dto.WxMaJscode2SessionDTO;
import com.elitesland.yst.common.base.ApiResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.StringUtils;

public class WechatAppletServiceImpl
implements WechatAppletService {
    private static final Logger log = LogManager.getLogger(WechatAppletServiceImpl.class);
    private final RmiSysUserRpcService rmiSysUserRpcService;
    private final WechatProperties wechatProperties;
    private Map<String, WxMaService> maServices;

    public WechatAppletServiceImpl(RmiSysUserRpcService rmiSysUserRpcService, WechatProperties wechatProperties) {
        this.rmiSysUserRpcService = rmiSysUserRpcService;
        this.wechatProperties = wechatProperties;
    }

    @Override
    public ApiResult<WxMaJscode2SessionDTO> login(String appId, String code) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)code)) {
            return ApiResult.fail((String)"code\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            WxMaService wxService = this.maServices.get(appId);
            WxMaJscode2SessionResult session = wxService.getUserService().getSessionInfo(code);
            WxMaJscode2SessionDTO wxMaJscode2SessionDTO = new WxMaJscode2SessionDTO();
            wxMaJscode2SessionDTO.setSessionKey(session.getSessionKey());
            wxMaJscode2SessionDTO.setOpenid(session.getOpenid());
            wxMaJscode2SessionDTO.setUnionid(session.getUnionid());
            return ApiResult.ok((Object)wxMaJscode2SessionDTO);
        }
        catch (Exception e) {
            return ApiResult.fail((String)e.getMessage());
        }
    }

    @Override
    public ApiResult<String> sysUserBindingWx(String userName, String appId, String wxCode) {
        try {
            if (StringUtils.isEmpty((Object)userName) || StringUtils.isEmpty((Object)appId) || StringUtils.isEmpty((Object)wxCode)) {
                return ApiResult.fail((String)"\u7ed1\u5b9a\u7684Username\u5fae\u4fe1appId\u6216code\u4e0d\u6b63\u786e");
            }
            ApiResult<WxMaJscode2SessionDTO> wxApiResult = this.login(appId, wxCode);
            if (wxApiResult.isSuccess()) {
                WxMaJscode2SessionDTO wxMaJscode2SessionResult = (WxMaJscode2SessionDTO)wxApiResult.getData();
                if (wxMaJscode2SessionResult != null && wxMaJscode2SessionResult.getOpenid() != null) {
                    return this.rmiSysUserRpcService.updateUserWechatOpenid(userName, wxMaJscode2SessionResult.getOpenid());
                }
                return ApiResult.fail((String)"\u5fae\u4fe1\u8ba4\u8bc1\u5931\u8d25:\u6ca1\u6709\u83b7\u53d6\u5230openid");
            }
            return ApiResult.fail((String)("\u5fae\u4fe1\u8ba4\u8bc1\u5931\u8d25:" + wxApiResult.getErrorMsg() + wxApiResult.getMsg()));
        }
        catch (Exception e) {
            return ApiResult.fail((String)("\u5fae\u4fe1\u7ed1\u5b9a\u5f02\u5e38:" + e.getMessage()));
        }
    }

    @PostConstruct
    private void init() {
        List<WechatProperties.App> configs = this.wechatProperties.getApps();
        if (configs.isEmpty()) {
            WechatProperties.App config = new WechatProperties.App();
            config.setAppid("");
            config.setSecret("");
            config.setMsgDataFormat("JSON");
            configs = new ArrayList<WechatProperties.App>();
            configs.add(config);
        }
        this.maServices = configs.stream().map(a -> {
            WxMaDefaultConfigImpl config = new WxMaDefaultConfigImpl();
            config.setAppid(a.getAppid());
            config.setSecret(a.getSecret());
            config.setToken(a.getToken());
            config.setAesKey(a.getAesKey());
            config.setMsgDataFormat(a.getMsgDataFormat());
            WxMaServiceImpl service = new WxMaServiceImpl();
            service.setWxMaConfig((WxMaConfig)config);
            return service;
        }).collect(Collectors.toMap(s -> s.getWxMaConfig().getAppid(), a -> a));
    }
}

