/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.authorization.api.provider.security.configurer;

import com.elitesland.cloudt.authorization.api.provider.security.configurer.AbstractCustomAuthenticationFilterConfigurer;
import com.elitesland.cloudt.authorization.api.provider.security.configurer.support.LoginFilterCustomizer;
import com.elitesland.cloudt.authorization.api.provider.security.grant.AbstractCustomAuthenticationProvider;
import com.elitesland.cloudt.authorization.api.provider.security.grant.AbstractCustomAuthenticationToken;
import com.elitesland.cloudt.authorization.api.provider.security.grant.CustomGrantAuthenticationFilter;
import com.elitesland.cloudt.authorization.api.provider.security.grant.account_pwd.AccountPasswordAuthenticationProvider;
import com.elitesland.cloudt.authorization.api.provider.security.grant.client_user.ClientUserAuthenticationProvider;
import com.elitesland.cloudt.authorization.api.provider.security.grant.mobile_pwd.MobilePasswordAuthenticationProvider;
import com.elitesland.cloudt.authorization.api.provider.security.grant.mobile_sms.MobileSmsAuthenticationProvider;
import com.elitesland.cloudt.authorization.api.provider.security.grant.password.UsernamePasswordAuthenticationProvider;
import com.elitesland.cloudt.authorization.api.provider.security.grant.wx_minapp.WechatOpenidAuthenticationProvider;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.lang.NonNull;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

public class LoginFilterSecurityConfigurer<H extends HttpSecurityBuilder<H>>
extends AbstractCustomAuthenticationFilterConfigurer<H, LoginFilterSecurityConfigurer<H>, CustomGrantAuthenticationFilter> {
    private static final Logger log = LogManager.getLogger(LoginFilterSecurityConfigurer.class);
    private String loginProcessingUrl = "/oauth/login";
    private final List<AbstractCustomAuthenticationProvider<?>> customAuthenticationProviders = new ArrayList();
    private final ObjectProvider<LoginFilterCustomizer<H>> objectProvider;

    public LoginFilterSecurityConfigurer(ObjectProvider<LoginFilterCustomizer<H>> objectProvider) {
        this.objectProvider = objectProvider;
    }

    public LoginFilterSecurityConfigurer<H> addCustomAuthenticationProvider(@NonNull List<AbstractCustomAuthenticationProvider<?>> authenticationProviders) {
        this.customAuthenticationProviders.addAll(authenticationProviders);
        return this;
    }

    @Override
    public void init(H http) throws Exception {
        CustomGrantAuthenticationFilter authenticationFilter = new CustomGrantAuthenticationFilter(this.loginProcessingUrl);
        this.setAuthenticationFilter(authenticationFilter);
        super.loginProcessingUrl(this.loginProcessingUrl);
        this.objectProvider.stream().forEach(loginFilterCustomizer -> loginFilterCustomizer.customizer(this));
        if (this.customAuthenticationProviders.isEmpty()) {
            this.customAuthenticationProviders.addAll(this.defaultAuthenticationProviders());
        }
        for (AbstractCustomAuthenticationProvider<?> customAuthenticationProvider : this.customAuthenticationProviders) {
            Constructor<?> tokenConstructor = customAuthenticationProvider.getAuthenticationTokenType().getConstructor(new Class[0]);
            authenticationFilter.addAuthenticationTokenConvert((AbstractCustomAuthenticationToken)((Object)tokenConstructor.newInstance(new Object[0])));
            http.authenticationProvider((AuthenticationProvider)this.postProcess(customAuthenticationProvider));
        }
        super.init(http);
    }

    @Override
    public void configure(H http) throws Exception {
        ((CustomGrantAuthenticationFilter)((Object)this.getAuthenticationFilter())).setFilterProcessesUrl(this.loginProcessingUrl);
        super.configure(http);
    }

    @Override
    protected RequestMatcher createLoginProcessingUrlMatcher(String loginProcessingUrl) {
        return new AntPathRequestMatcher(loginProcessingUrl);
    }

    @Override
    public LoginFilterSecurityConfigurer<H> loginProcessingUrl(String loginProcessingUrl) {
        Assert.hasText((String)loginProcessingUrl, (String)"loginProcessingUrl cannot be empty");
        this.loginProcessingUrl = loginProcessingUrl;
        return this;
    }

    public List<AbstractCustomAuthenticationProvider<?>> defaultAuthenticationProviders() {
        return List.of(new AccountPasswordAuthenticationProvider(), new ClientUserAuthenticationProvider(), new MobilePasswordAuthenticationProvider(), new MobileSmsAuthenticationProvider(), new UsernamePasswordAuthenticationProvider(), new WechatOpenidAuthenticationProvider());
    }
}

