/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.authorization.api.provider.security.configurer.filter;

import java.io.IOException;
import java.security.Principal;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpMethod;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.core.OAuth2TokenType;
import org.springframework.security.oauth2.server.authorization.OAuth2Authorization;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class OAuth2AuthorizationCodeStateAuthenticationFilter
extends OncePerRequestFilter {
    private static final Logger log = LogManager.getLogger(OAuth2AuthorizationCodeStateAuthenticationFilter.class);
    private static final OAuth2TokenType TOKEN_TYPE = new OAuth2TokenType("state");
    private final RequestMatcher oauth2AuthorizationEndpointRequestMatcher;
    private final OAuth2AuthorizationService authorizationService;

    public OAuth2AuthorizationCodeStateAuthenticationFilter(String oauth2AuthorizationEndpoint, OAuth2AuthorizationService authorizationService) {
        this.oauth2AuthorizationEndpointRequestMatcher = this.buildOAuth2AuthorizationEndpointRequestMatcher(oauth2AuthorizationEndpoint);
        this.authorizationService = authorizationService;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (!this.oauth2AuthorizationEndpointRequestMatcher.matches(request)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String state = request.getParameter("state");
        String clientId = request.getParameter("client_id");
        if (!StringUtils.hasText((String)state) || !StringUtils.hasText((String)clientId)) {
            log.warn("\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570\uff0c\u8ba4\u8bc1\u8bf7\u6c42\u5ffd\u7565\uff1a{}\uff0c{}", (Object)state, (Object)clientId);
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        Authentication authentication = this.authentication(clientId, state);
        if (authentication != null) {
            SecurityContext context = SecurityContextHolder.createEmptyContext();
            context.setAuthentication(authentication);
            SecurityContextHolder.setContext((SecurityContext)context);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private Authentication authentication(String clientId, String state) {
        OAuth2Authorization oAuth2Authorization = this.authorizationService.findByToken(state, TOKEN_TYPE);
        if (oAuth2Authorization == null) {
            log.info("\u672a\u627e\u5230OAuth2Authorization\uff1a{}\uff0c\u9700\u767b\u5f55\u8ba4\u8bc1", (Object)state);
            return null;
        }
        if (!clientId.equals(oAuth2Authorization.getAttribute("client_id"))) {
            log.info("\u5ba2\u6237\u7aef{}, {}\u4e0d\u4e00\u81f4\uff0c\u9700\u767b\u5f55\u8ba4\u8bc1", (Object)clientId, (Object)clientId);
            return null;
        }
        return (Authentication)oAuth2Authorization.getAttribute(Principal.class.getName());
    }

    private RequestMatcher buildOAuth2AuthorizationEndpointRequestMatcher(String oauth2Authorizationendpoint) {
        return new OrRequestMatcher(new RequestMatcher[]{new AntPathRequestMatcher(oauth2Authorizationendpoint, HttpMethod.GET.name()), new AntPathRequestMatcher(oauth2Authorizationendpoint, HttpMethod.POST.name())});
    }
}

