/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.authorization.api.provider.security.grant;

import com.elitesland.cloudt.authorization.api.provider.common.LoginType;
import com.elitesland.cloudt.authorization.api.provider.security.grant.AbstractCustomAuthenticationToken;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class CustomGrantAuthenticationFilter
extends AbstractAuthenticationProcessingFilter {
    public static final String DEFAULT_FILTER_PROCESS_URI = "/oauth/login";
    private final Map<String, AbstractCustomAuthenticationToken<?>> authenticationTokenMap = new HashMap();

    public CustomGrantAuthenticationFilter() {
        this(DEFAULT_FILTER_PROCESS_URI);
    }

    public CustomGrantAuthenticationFilter(String defaultFilterProcessesUrl) {
        super((RequestMatcher)new AntPathRequestMatcher(defaultFilterProcessesUrl, HttpMethod.POST.name()));
    }

    public <T extends AbstractCustomAuthenticationToken> void addAuthenticationTokenConvert(T authenticationToken) {
        LoginType loginType = authenticationToken.loginType();
        Assert.notNull((Object)loginType, (String)(((Object)authenticationToken).getClass().getName() + "\u7684loginType\u4e3a\u7a7a"));
        this.authenticationTokenMap.put(loginType.getType(), authenticationToken);
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException, IOException, ServletException {
        String loginType = request.getParameter("login_type");
        if (!StringUtils.hasText((String)loginType)) {
            throw new AuthenticationServiceException("\u672a\u77e5\u767b\u5f55\u7c7b\u578b");
        }
        AbstractCustomAuthenticationToken<?> authenticationToken = this.authenticationTokenMap.get(loginType);
        if (authenticationToken == null) {
            throw new AuthenticationServiceException("\u4e0d\u652f\u6301\u7684\u767b\u5f55\u7c7b\u578b");
        }
        Object authentication = authenticationToken.convert(request);
        this.setDetails(request, (AbstractAuthenticationToken)authentication);
        return this.getAuthenticationManager().authenticate(authentication);
    }

    private void setDetails(HttpServletRequest request, AbstractAuthenticationToken authentication) {
        authentication.setDetails(this.authenticationDetailsSource.buildDetails((Object)request));
    }
}

