/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.authorization.api.provider.security.grant.account_pwd;

import com.elitesland.cloudt.authorization.api.client.common.AuthorizationException;
import com.elitesland.cloudt.authorization.api.provider.provider.LoginSupportProvider;
import com.elitesland.cloudt.authorization.api.provider.security.grant.AbstractCustomAuthenticationProvider;
import com.elitesland.cloudt.authorization.api.provider.security.grant.account_pwd.AccountPasswordAuthenticationToken;
import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.security.entity.GeneralUserDetails;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.NonNull;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.util.StringUtils;

public class AccountPasswordAuthenticationProvider
extends AbstractCustomAuthenticationProvider<AccountPasswordAuthenticationToken> {
    private static final Logger log = LogManager.getLogger(AccountPasswordAuthenticationProvider.class);
    @Autowired
    private LoginSupportProvider loginSupportManager;

    @Override
    @NonNull
    protected GeneralUserDetails retrieveUser(AccountPasswordAuthenticationToken authentication) throws AuthenticationException {
        String account = (String)authentication.getPrincipal();
        if (!StringUtils.hasText((String)account)) {
            throw new AuthorizationException("\u8d26\u53f7\u4e3a\u7a7a");
        }
        this.checkCaptcha(authentication);
        return this.userDetailManager.loadUserByAccount(account);
    }

    @Override
    protected void additionalAuthenticationChecks(GeneralUserDetails userDetails, AccountPasswordAuthenticationToken authentication) throws AuthenticationException {
        super.additionalAuthenticationChecks(userDetails, authentication);
        if (authentication.getCredentials() == null) {
            log.debug("Failed to authenticate since no credentials provided");
            throw new BadCredentialsException("\u8d26\u53f7\u6216\u5bc6\u7801\u4e0d\u6b63\u786e");
        }
        String presentedPassword = authentication.getCredentials().toString();
        if (!this.passwordEncoder.matches((CharSequence)presentedPassword, userDetails.getPassword())) {
            log.debug("Failed to authenticate since password does not match stored value");
            throw new BadCredentialsException("\u8d26\u53f7\u6216\u5bc6\u7801\u4e0d\u6b63\u786e");
        }
    }

    private void checkCaptcha(AccountPasswordAuthenticationToken authentication) {
        Boolean need = authentication.getCaptchaNeeded();
        if (need != null && !need.booleanValue()) {
            return;
        }
        ApiResult<Boolean> verifyResult = this.loginSupportManager.verifyCaptcha(authentication.getCaptchaKey(), authentication.getCaptchaText());
        if (!verifyResult.isSuccess()) {
            throw new AuthorizationException(verifyResult.getMsg());
        }
        if (verifyResult.getData() == null || !((Boolean)verifyResult.getData()).booleanValue()) {
            throw new AuthorizationException("\u9a8c\u8bc1\u7801\u5df2\u8fc7\u671f\u6216\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
    }
}

