/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.authorization.api.provider.security.grant.mobile_pwd;

import com.elitesland.cloudt.authorization.api.client.util.HttpServletUtil;
import com.elitesland.cloudt.authorization.api.provider.common.LoginType;
import com.elitesland.cloudt.authorization.api.provider.security.grant.AbstractCustomAuthenticationToken;
import com.elitesland.yst.common.constant.Terminal;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.springframework.lang.NonNull;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class MobilePasswordAuthenticationToken
extends AbstractCustomAuthenticationToken<MobilePasswordAuthenticationToken> {
    private static final long serialVersionUID = -2118788872828941269L;

    public MobilePasswordAuthenticationToken() {
        super(null, null);
    }

    public MobilePasswordAuthenticationToken(Object principal, Object credentials) {
        super(principal, credentials);
    }

    public MobilePasswordAuthenticationToken(Object principal, Object credentials, Collection<? extends GrantedAuthority> authorities) {
        super(principal, credentials, authorities);
    }

    @Override
    @NonNull
    public LoginType loginType() {
        return LoginType.MOBILE_PWD;
    }

    @Override
    @NonNull
    public MobilePasswordAuthenticationToken convert(@NonNull HttpServletRequest request) {
        MultiValueMap parameters = HttpServletUtil.getParameters((HttpServletRequest)request);
        String terminalParam = (String)parameters.getFirst((Object)"terminal");
        Terminal terminal = null;
        if (StringUtils.hasText((String)terminalParam)) {
            terminal = Terminal.parse((String)terminalParam);
        }
        MobilePasswordAuthenticationToken authenticationToken = new MobilePasswordAuthenticationToken();
        authenticationToken.setTerminal(terminal);
        authenticationToken.setPrincipal(parameters.getFirst((Object)"mobile"));
        authenticationToken.setCredentials(parameters.getFirst((Object)"password"));
        authenticationToken.setAuthenticated(false);
        return authenticationToken;
    }
}

