/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.authorization.api.provider.security.grant.wx_minapp;

import com.elitesland.cloudt.authorization.api.client.common.AuthorizationException;
import com.elitesland.cloudt.authorization.api.provider.provider.user.UserDetailManager;
import com.elitesland.cloudt.authorization.api.provider.provider.wechat.WechatAppletService;
import com.elitesland.cloudt.authorization.api.provider.provider.wechat.dto.WxMaJscode2SessionDTO;
import com.elitesland.cloudt.authorization.api.provider.security.grant.AbstractCustomAuthenticationProvider;
import com.elitesland.cloudt.authorization.api.provider.security.grant.wx_minapp.WechatOpenidAuthenticationToken;
import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.security.entity.GeneralUserDetails;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.AuthenticationException;
import org.springframework.util.StringUtils;

public class WechatOpenidAuthenticationProvider
extends AbstractCustomAuthenticationProvider<WechatOpenidAuthenticationToken> {
    private static final Logger log = LogManager.getLogger(WechatOpenidAuthenticationProvider.class);
    @Autowired
    private WechatAppletService wechatAppletService;
    @Autowired
    private UserDetailManager userDetailManager;

    @Override
    protected GeneralUserDetails retrieveUser(WechatOpenidAuthenticationToken authentication) throws AuthenticationException {
        String appId = (String)authentication.getPrincipal();
        String wxCode = (String)authentication.getCredentials();
        if (!StringUtils.hasText((String)appId) || !StringUtils.hasText((String)wxCode)) {
            throw new AuthorizationException("\u8bf7\u6c42\u6709\u8bef\uff0c\u53c2\u6570\u4e0d\u5b8c\u6574");
        }
        String openId = this.obtainOpenid(appId, wxCode);
        return this.userDetailManager.loadUserByWechatOpenid(openId);
    }

    private String obtainOpenid(String appId, String wxCode) {
        ApiResult<WxMaJscode2SessionDTO> loginResult = this.wechatAppletService.login(appId, wxCode);
        if (loginResult.getData() == null || !StringUtils.hasText((String)((WxMaJscode2SessionDTO)loginResult.getData()).getOpenid())) {
            throw new AuthorizationException("\u767b\u5f55\u5931\u8d25\uff1a" + loginResult.getMsg());
        }
        return ((WxMaJscode2SessionDTO)loginResult.getData()).getOpenid();
    }
}

