/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.authorization.api.provider.security.grant.wx_minapp;

import com.elitesland.cloudt.authorization.api.client.util.HttpServletUtil;
import com.elitesland.cloudt.authorization.api.provider.common.LoginType;
import com.elitesland.cloudt.authorization.api.provider.security.grant.AbstractCustomAuthenticationToken;
import com.elitesland.yst.common.constant.Terminal;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.springframework.lang.NonNull;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class WechatOpenidAuthenticationToken
extends AbstractCustomAuthenticationToken<WechatOpenidAuthenticationToken> {
    private static final long serialVersionUID = 35697051927011289L;

    public WechatOpenidAuthenticationToken() {
        super(null, null);
    }

    public WechatOpenidAuthenticationToken(Object principal, Object credentials) {
        super(principal, credentials);
    }

    public WechatOpenidAuthenticationToken(Object principal, Object credentials, Collection<? extends GrantedAuthority> authorities) {
        super(principal, credentials, authorities);
    }

    @Override
    @NonNull
    public LoginType loginType() {
        return LoginType.WX_MINAPP;
    }

    @Override
    @NonNull
    public WechatOpenidAuthenticationToken convert(@NonNull HttpServletRequest request) {
        MultiValueMap parameters = HttpServletUtil.getParameters((HttpServletRequest)request);
        String terminalParam = (String)parameters.getFirst((Object)"terminal");
        Terminal terminal = null;
        if (StringUtils.hasText((String)terminalParam)) {
            terminal = Terminal.parse((String)terminalParam);
        }
        WechatOpenidAuthenticationToken authenticationToken = new WechatOpenidAuthenticationToken();
        authenticationToken.setTerminal(terminal);
        authenticationToken.setPrincipal(parameters.getFirst((Object)"wx_appid"));
        authenticationToken.setCredentials(parameters.getFirst((Object)"wx_code"));
        authenticationToken.setAuthenticated(false);
        return authenticationToken;
    }
}

