/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.authorization.api.provider.security.handler;

import com.elitesland.cloudt.authorization.api.client.config.AuthorizationProperties;
import com.elitesland.cloudt.authorization.api.client.config.security.handler.DefaultAuthenticationSuccessHandler;
import com.elitesland.cloudt.authorization.api.client.config.support.AuthenticationCache;
import com.elitesland.cloudt.authorization.api.client.model.OAuthToken;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import org.springframework.lang.NonNull;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2TokenType;
import org.springframework.security.oauth2.jose.jws.JwsAlgorithm;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.security.oauth2.jwt.JwsHeader;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtClaimsSet;
import org.springframework.security.oauth2.jwt.JwtEncoder;
import org.springframework.security.oauth2.jwt.JwtEncoderParameters;
import org.springframework.security.oauth2.server.authorization.token.JwtEncodingContext;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenContext;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenCustomizer;

public class JwtAuthenticationSuccessHandler
extends DefaultAuthenticationSuccessHandler {
    private static final String ISSUER_DEFAULT = "cloudt";
    private final JwtEncoder jwtEncoder;
    private OAuth2TokenCustomizer<JwtEncodingContext> tokenCustomizer;

    public JwtAuthenticationSuccessHandler(AuthorizationProperties authorizationProperties, AuthenticationCache authenticationCache, @NonNull JwtEncoder jwtEncoder) {
        super(authorizationProperties, authenticationCache);
        this.jwtEncoder = jwtEncoder;
    }

    protected Object convertResponseResult(HttpServletRequest request, Authentication authentication) {
        Jwt jwt = this.generateJwt(authentication);
        return this.convertToken(jwt);
    }

    protected String generateCacheKey(HttpServletRequest request, Object responseResult, Authentication authentication) {
        OAuthToken authToken = (OAuthToken)responseResult;
        return authToken.getAccessToken();
    }

    private Jwt generateJwt(Authentication authentication) {
        Instant issuedAt = Instant.now();
        JwtClaimsSet.Builder claimBuilder = JwtClaimsSet.builder().issuer(ISSUER_DEFAULT).subject(authentication.getName()).audience(Collections.singletonList(authentication.getName())).issuedAt(issuedAt).expiresAt(issuedAt.plus(30L, ChronoUnit.MINUTES));
        JwsHeader.Builder headersBuilder = JwsHeader.with((JwsAlgorithm)SignatureAlgorithm.RS256);
        JwtEncodingContext.Builder jwtContextBuilder = (JwtEncodingContext.Builder)((JwtEncodingContext.Builder)((JwtEncodingContext.Builder)JwtEncodingContext.with((JwsHeader.Builder)headersBuilder, (JwtClaimsSet.Builder)claimBuilder).principal(authentication)).tokenType(OAuth2TokenType.ACCESS_TOKEN)).authorizationGrantType(AuthorizationGrantType.JWT_BEARER);
        JwtEncodingContext jwtContext = jwtContextBuilder.build();
        if (this.tokenCustomizer != null) {
            this.tokenCustomizer.customize((OAuth2TokenContext)jwtContext);
        }
        JwsHeader headers = headersBuilder.build();
        JwtClaimsSet claims = claimBuilder.build();
        return this.jwtEncoder.encode(JwtEncoderParameters.from((JwsHeader)headers, (JwtClaimsSet)claims));
    }

    public void setTokenCustomizer(OAuth2TokenCustomizer<JwtEncodingContext> tokenCustomizer) {
        this.tokenCustomizer = tokenCustomizer;
    }

    private OAuthToken convertToken(Jwt jwt) {
        OAuthToken token = new OAuthToken();
        token.setAccessToken(jwt.getTokenValue());
        token.setTokenType(OAuth2AccessToken.TokenType.BEARER.getValue());
        long expiresIn = ChronoUnit.SECONDS.between(Instant.now(), jwt.getExpiresAt());
        token.setExpiresIn(Long.valueOf(expiresIn));
        token.setScope(Collections.emptySet());
        token.setRefreshToken(null);
        return token;
    }
}

