/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.authorization.api.provider.security.handler.oauth2.server;

import com.elitesland.cloudt.authorization.api.client.config.security.handler.AbstractHandler;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeRequestAuthenticationException;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeRequestAuthenticationToken;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class AbstractOAuth2ServerHandler
extends AbstractHandler {
    private final RedirectStrategy redirectStrategy = new DefaultRedirectStrategy();

    protected void sendAuthorizationResponse(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException {
        OAuth2AuthorizationCodeRequestAuthenticationToken authorizationCodeRequestAuthentication = (OAuth2AuthorizationCodeRequestAuthenticationToken)authentication;
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)authorizationCodeRequestAuthentication.getRedirectUri()).queryParam("code", new Object[]{authorizationCodeRequestAuthentication.getAuthorizationCode().getTokenValue()});
        if (StringUtils.hasText((String)authorizationCodeRequestAuthentication.getState())) {
            uriBuilder.queryParam("state", new Object[]{authorizationCodeRequestAuthentication.getState()});
        }
        this.redirectStrategy.sendRedirect(request, response, uriBuilder.toUriString());
    }

    protected void sendErrorResponse(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException {
        OAuth2AuthorizationCodeRequestAuthenticationException authorizationCodeRequestAuthenticationException = (OAuth2AuthorizationCodeRequestAuthenticationException)exception;
        OAuth2Error error = authorizationCodeRequestAuthenticationException.getError();
        OAuth2AuthorizationCodeRequestAuthenticationToken authorizationCodeRequestAuthentication = authorizationCodeRequestAuthenticationException.getAuthorizationCodeRequestAuthentication();
        if (authorizationCodeRequestAuthentication == null || !StringUtils.hasText((String)authorizationCodeRequestAuthentication.getRedirectUri())) {
            response.sendError(HttpStatus.BAD_REQUEST.value(), error.toString());
            return;
        }
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)authorizationCodeRequestAuthentication.getRedirectUri()).queryParam("error", new Object[]{error.getErrorCode()});
        if (StringUtils.hasText((String)error.getDescription())) {
            uriBuilder.queryParam("error_description", new Object[]{error.getDescription()});
        }
        if (StringUtils.hasText((String)error.getUri())) {
            uriBuilder.queryParam("error_uri", new Object[]{error.getUri()});
        }
        if (StringUtils.hasText((String)authorizationCodeRequestAuthentication.getState())) {
            uriBuilder.queryParam("state", new Object[]{authorizationCodeRequestAuthentication.getState()});
        }
        this.redirectStrategy.sendRedirect(request, response, uriBuilder.toUriString());
    }
}

