/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.authorization.api.provider.security.handler.oauth2.server;

import com.elitesland.cloudt.authorization.api.provider.security.handler.oauth2.server.AbstractOAuth2ServerHandler;
import com.elitesland.cloudt.authorization.api.provider.security.handler.oauth2.server.support.OAuth2AuthorizationCodeRequestCache;
import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.base.ApiResult;
import java.io.IOException;
import java.time.Duration;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeRequestAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.web.authentication.OAuth2AuthorizationCodeRequestAuthenticationConverter;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class OAuth2ServerAuthenticationEntryPointHandler
extends AbstractOAuth2ServerHandler
implements AuthenticationEntryPoint {
    private static final Logger log = LogManager.getLogger(OAuth2ServerAuthenticationEntryPointHandler.class);
    private static final Duration CODE_REQUEST_TTL = Duration.ofMinutes(5L);
    private final OAuth2AuthorizationCodeRequestCache authorizationCodeRequestCache;
    private final RequestMatcher oauth2AuthorizationEndpointRequestMatcher;

    public OAuth2ServerAuthenticationEntryPointHandler(OAuth2AuthorizationCodeRequestCache authorizationCodeRequestCache, String oauth2AuthorizationEndpoint) {
        this.authorizationCodeRequestCache = authorizationCodeRequestCache;
        this.oauth2AuthorizationEndpointRequestMatcher = this.buildOAuth2AuthorizationEndpointRequestMatcher(oauth2AuthorizationEndpoint);
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        log.info("\u672a\u8ba4\u8bc1\u8bf7\u6c42\uff1a{}", (Object)request.getRequestURI());
        this.cacheAuthorizeRequest(request);
        this.writeResponse(response, ApiResult.fail((ApiCode)ApiCode.UNAUTHORIZED, (String)"\u672a\u8ba4\u8bc1\u6216\u8eab\u4efd\u8ba4\u8bc1\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55"), HttpStatus.UNAUTHORIZED);
    }

    private void cacheAuthorizeRequest(HttpServletRequest request) {
        if (!this.oauth2AuthorizationEndpointRequestMatcher.matches(request)) {
            return;
        }
        OAuth2AuthorizationCodeRequestAuthenticationToken codeRequest = (OAuth2AuthorizationCodeRequestAuthenticationToken)new OAuth2AuthorizationCodeRequestAuthenticationConverter().convert(request);
        this.authorizationCodeRequestCache.setAuthenticationToken(codeRequest.getState(), codeRequest, CODE_REQUEST_TTL);
    }

    private RequestMatcher buildOAuth2AuthorizationEndpointRequestMatcher(String oauth2Authorizationendpoint) {
        return new OrRequestMatcher(new RequestMatcher[]{new AntPathRequestMatcher(oauth2Authorizationendpoint, HttpMethod.GET.name()), new AntPathRequestMatcher(oauth2Authorizationendpoint, HttpMethod.POST.name())});
    }
}

