/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.authorization.api.provider.security.handler.oauth2.server;

import com.elitesland.cloudt.authorization.api.client.model.OAuthToken;
import com.elitesland.cloudt.authorization.api.provider.security.handler.oauth2.server.AbstractOAuth2ServerHandler;
import com.elitesland.cloudt.authorization.api.provider.security.handler.oauth2.server.support.OAuth2AuthorizationCodeRequestCache;
import com.elitesland.yst.common.base.ApiResult;
import java.io.IOException;
import java.security.Principal;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2RefreshToken;
import org.springframework.security.oauth2.core.endpoint.OAuth2AccessTokenResponse;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.security.oauth2.server.authorization.OAuth2Authorization;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AccessTokenAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeRequestAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class OAuth2ServerAuthenticationSuccessHandler
extends AbstractOAuth2ServerHandler
implements AuthenticationSuccessHandler {
    private static final Logger log = LogManager.getLogger(OAuth2ServerAuthenticationSuccessHandler.class);
    private final OAuth2AuthorizationCodeRequestCache authorizationCodeRequestCache;
    private final RegisteredClientRepository clientRepository;
    private final OAuth2AuthorizationService oAuth2AuthorizationService;

    public OAuth2ServerAuthenticationSuccessHandler(OAuth2AuthorizationCodeRequestCache authorizationCodeRequestCache, RegisteredClientRepository clientRepository, OAuth2AuthorizationService oAuth2AuthorizationService) {
        this.authorizationCodeRequestCache = authorizationCodeRequestCache;
        this.clientRepository = clientRepository;
        this.oAuth2AuthorizationService = oAuth2AuthorizationService;
    }

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        if (authentication instanceof OAuth2AuthorizationCodeRequestAuthenticationToken) {
            this.forOAuth2AuthorizationCode(request, response, (OAuth2AuthorizationCodeRequestAuthenticationToken)authentication);
            return;
        }
        if (authentication instanceof OAuth2AccessTokenAuthenticationToken) {
            this.forAccessToken(request, response, (OAuth2AccessTokenAuthenticationToken)authentication);
            return;
        }
        this.forLogin(request, response, authentication);
    }

    private void forLogin(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        String state = request.getParameter("state");
        if (!StringUtils.hasText((String)state)) {
            log.warn("\u7f3a\u5c11state\u53c2\u6570");
            return;
        }
        OAuth2AuthorizationCodeRequestAuthenticationToken codeRequest = this.authorizationCodeRequestCache.getAuthenticationToken(state);
        if (codeRequest == null) {
            log.error("\u672a\u627e\u5230\u6388\u6743\u7801\u8ba4\u8bc1\u8bf7\u6c42\u4fe1\u606f\uff1a{}", (Object)state);
            return;
        }
        RegisteredClient client = this.clientRepository.findByClientId(codeRequest.getClientId());
        OAuth2AuthorizationRequest authorizationRequest = OAuth2AuthorizationRequest.authorizationCode().authorizationUri(codeRequest.getAuthorizationUri()).clientId(codeRequest.getClientId()).redirectUri(codeRequest.getRedirectUri()).scopes(codeRequest.getScopes()).state(codeRequest.getState()).additionalParameters(codeRequest.getAdditionalParameters()).build();
        OAuth2Authorization authorization = OAuth2ServerAuthenticationSuccessHandler.authorizationBuilder(client, authentication, authorizationRequest).attribute("state", (Object)codeRequest.getState()).attribute("client_id", (Object)codeRequest.getClientId()).build();
        this.oAuth2AuthorizationService.save(authorization);
        this.authorizationCodeRequestCache.removeAuthenticationToken(state);
    }

    private void forOAuth2AuthorizationCode(HttpServletRequest request, HttpServletResponse response, OAuth2AuthorizationCodeRequestAuthenticationToken authentication) throws IOException {
        if (this.supportRedirect(request)) {
            this.sendAuthorizationResponse(request, response, (Authentication)authentication);
            return;
        }
        HashMap<String, String> result = new HashMap<String, String>(4);
        result.put("code", authentication.getAuthorizationCode().getTokenValue());
        if (StringUtils.hasText((String)authentication.getState())) {
            result.put("state", authentication.getState());
        }
        this.writeResponse(response, ApiResult.ok(result));
    }

    private void forAccessToken(HttpServletRequest request, HttpServletResponse response, OAuth2AccessTokenAuthenticationToken accessTokenAuthentication) throws IOException {
        OAuth2AccessToken accessToken = accessTokenAuthentication.getAccessToken();
        OAuth2RefreshToken refreshToken = accessTokenAuthentication.getRefreshToken();
        Map additionalParameters = accessTokenAuthentication.getAdditionalParameters();
        OAuth2AccessTokenResponse.Builder builder = OAuth2AccessTokenResponse.withToken((String)accessToken.getTokenValue()).tokenType(accessToken.getTokenType()).scopes(accessToken.getScopes());
        if (accessToken.getIssuedAt() != null && accessToken.getExpiresAt() != null) {
            builder.expiresIn(ChronoUnit.SECONDS.between(accessToken.getIssuedAt(), accessToken.getExpiresAt()));
        }
        if (refreshToken != null) {
            builder.refreshToken(refreshToken.getTokenValue());
        }
        if (!CollectionUtils.isEmpty((Map)additionalParameters)) {
            builder.additionalParameters(additionalParameters);
        }
        OAuth2AccessTokenResponse accessTokenResponse = builder.build();
        OAuthToken oauthToken = OAuth2ServerAuthenticationSuccessHandler.convertOAuth2AccessToken(accessTokenResponse);
        this.writeResponse(response, ApiResult.ok((Object)oauthToken));
    }

    private static OAuthToken convertOAuth2AccessToken(OAuth2AccessTokenResponse tokenResponse) {
        OAuthToken token = new OAuthToken();
        token.setAccessToken(tokenResponse.getAccessToken().getTokenValue());
        token.setTokenType(tokenResponse.getAccessToken().getTokenType().getValue());
        token.setExpiresIn(Long.valueOf(OAuth2ServerAuthenticationSuccessHandler.getExpiresIn(tokenResponse)));
        token.setScope(Objects.requireNonNullElse(tokenResponse.getAccessToken().getScopes(), Collections.emptySet()));
        OAuth2RefreshToken refreshToken = tokenResponse.getRefreshToken();
        if (refreshToken != null) {
            token.setRefreshToken(refreshToken.getTokenValue());
        }
        return token;
    }

    private static long getExpiresIn(OAuth2AccessTokenResponse tokenResponse) {
        if (tokenResponse.getAccessToken().getExpiresAt() != null) {
            return ChronoUnit.SECONDS.between(Instant.now(), tokenResponse.getAccessToken().getExpiresAt());
        }
        return -1L;
    }

    private static OAuth2Authorization.Builder authorizationBuilder(RegisteredClient registeredClient, Authentication principal, OAuth2AuthorizationRequest authorizationRequest) {
        return OAuth2Authorization.withRegisteredClient((RegisteredClient)registeredClient).principalName(principal.getName()).authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE).attribute(Principal.class.getName(), (Object)principal).attribute(OAuth2AuthorizationRequest.class.getName(), (Object)authorizationRequest);
    }
}

