/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.authorization.api.provider.security.handler.oauth2.server;

import com.elitesland.cloudt.authorization.api.provider.security.handler.oauth2.server.AbstractOAuth2ServerHandler;
import com.elitesland.yst.common.base.ApiResult;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeRequestAuthenticationException;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeRequestAuthenticationToken;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.util.StringUtils;

public class OAuth2ServerErrorResponseHandler
extends AbstractOAuth2ServerHandler
implements AuthenticationFailureHandler {
    private static final Logger log = LogManager.getLogger(OAuth2ServerErrorResponseHandler.class);

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        if (this.supportRedirect(request)) {
            this.sendErrorResponse(request, response, exception);
            return;
        }
        this.sendErrorResponseByJson(request, response, exception);
    }

    private void sendErrorResponseByJson(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException {
        OAuth2AuthorizationCodeRequestAuthenticationException authorizationCodeRequestAuthenticationException = (OAuth2AuthorizationCodeRequestAuthenticationException)exception;
        OAuth2Error error = authorizationCodeRequestAuthenticationException.getError();
        OAuth2AuthorizationCodeRequestAuthenticationToken authorizationCodeRequestAuthentication = authorizationCodeRequestAuthenticationException.getAuthorizationCodeRequestAuthentication();
        if (authorizationCodeRequestAuthentication == null) {
            this.writeResponse(response, ApiResult.fail((String)"\u8bf7\u6c42\u65b9\u5f0f\u6216\u53c2\u6570\u6709\u8bef"), HttpStatus.BAD_REQUEST);
            return;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("error", error.getErrorCode());
        if (StringUtils.hasText((String)error.getDescription())) {
            result.put("error_description", error.getDescription());
        }
        if (StringUtils.hasText((String)error.getUri())) {
            result.put("error_uri", error.getUri());
        }
        if (StringUtils.hasText((String)authorizationCodeRequestAuthentication.getState())) {
            result.put("state", authorizationCodeRequestAuthentication.getState());
        }
        this.writeResponse(response, ApiResult.ok(result), HttpStatus.UNAUTHORIZED);
    }
}

