/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.authorization.api.provider.security.impl;

import com.elitesland.cloudt.authorization.api.client.common.AuthorizationException;
import com.elitesland.cloudt.authorization.api.provider.config.system.TenantProperties;
import com.elitesland.cloudt.authorization.api.provider.security.AuthenticationCheckService;
import com.elitesland.cloudt.authorization.api.provider.security.grant.AbstractCustomAuthenticationToken;
import com.elitesland.cloudt.context.util.HttpServletUtil;
import com.elitesland.yst.common.constant.Terminal;
import com.elitesland.yst.core.provider.tenant.TenantClientProvider;
import com.elitesland.yst.security.entity.GeneralUserDetails;
import com.elitesland.yst.system.dto.SysTenantDTO;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.core.AuthenticationException;
import org.springframework.util.CollectionUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class TenantAuthenticationCheckServiceImpl<T extends AbstractCustomAuthenticationToken<T>>
implements AuthenticationCheckService<T> {
    private static final Logger log = LogManager.getLogger(TenantAuthenticationCheckServiceImpl.class);
    private final TenantProperties tenantProperties;
    private final TenantClientProvider tenantClientProvider;

    public TenantAuthenticationCheckServiceImpl(TenantProperties tenantProperties, TenantClientProvider tenantClientProvider) {
        this.tenantProperties = tenantProperties;
        this.tenantClientProvider = tenantClientProvider;
    }

    @Override
    public void additionalAuthenticationChecks(GeneralUserDetails user, T authentication) throws AuthenticationException {
        if (!this.tenantClientProvider.enabledTenant() || !Boolean.TRUE.equals(this.tenantProperties.isLimitTenantLogin())) {
            return;
        }
        if (CollectionUtils.isEmpty((Collection)user.getUser().getSysTenantDTOList())) {
            return;
        }
        if (Terminal.BACKEND.name().equals(((AbstractCustomAuthenticationToken)((Object)authentication)).getTerminal())) {
            if (user.isSystemAdmin() || user.isOperation()) {
                return;
            }
            if (this.tenantClientProvider.isDefaultDomainRequest()) {
                throw new AuthorizationException("\u8bf7\u8f6c\u81f3\u5bf9\u5e94\u79df\u6237\u4e0b\u7684\u7ad9\u70b9\u767b\u5f55");
            }
            SysTenantDTO tenant = this.tenantClientProvider.obtainTenantFromRequest();
            if (tenant == null) {
                log.info("\u8bf7\u6c42\u57df\u540d\uff1a{}", (Object)this.obtainDomain());
                throw new AuthorizationException("\u672a\u77e5\u7ad9\u70b9\u6240\u5c5e\u79df\u6237");
            }
            if (user.getTenant() == null || !user.getTenant().getId().equals(tenant.getId())) {
                log.warn("\u767b\u5f55\u7528\u6237\u7684\u79df\u6237\uff1a{}", (Object)user.getTenant());
                throw new AuthorizationException("\u8bf7\u8f6c\u81f3\u79df\u6237\u4e0b\u7684\u7ad9\u70b9\u767b\u5f55");
            }
        }
    }

    private String obtainDomain() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes == null) {
            return null;
        }
        HttpServletRequest request = ((ServletRequestAttributes)requestAttributes).getRequest();
        String uri = request.getRequestURL().toString();
        String domain = HttpServletUtil.obtainDomain((HttpServletRequest)request);
        log.info("\u8bf7\u6c42\u8def\u5f84\uff1a{}, {}", (Object)uri, (Object)domain);
        return domain;
    }
}

