/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.authorization.api.provider.service.reposotory;

import com.elitesland.cloudt.authorization.api.provider.model.entity.OAuth2AuthorizationDO;
import com.elitesland.cloudt.authorization.api.provider.model.entity.QOAuth2AuthorizationDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.time.LocalDateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.oauth2.core.OAuth2TokenType;
import org.springframework.stereotype.Repository;

@Repository
public class OAuth2AuthenticationRepoProc {
    private static final QOAuth2AuthorizationDO QDO = QOAuth2AuthorizationDO.oAuth2AuthorizationDO;
    @Autowired
    private JPAQueryFactory jpaQueryFactory;

    public long delete(String id) {
        return this.jpaQueryFactory.delete((EntityPath)QDO).where(new Predicate[]{OAuth2AuthenticationRepoProc.QDO.id.eq((Object)id)}).execute();
    }

    public long deleteByAccessTokenExpiresAt(LocalDateTime expiredTime) {
        return this.jpaQueryFactory.delete((EntityPath)QDO).where(new Predicate[]{OAuth2AuthenticationRepoProc.QDO.accessTokenExpiresAt.before((Comparable)expiredTime)}).execute();
    }

    public long deleteByRefreshTokenExpiresAt(LocalDateTime expiredTime) {
        return this.jpaQueryFactory.delete((EntityPath)QDO).where(new Predicate[]{OAuth2AuthenticationRepoProc.QDO.refreshTokenExpiresAt.before((Comparable)expiredTime)}).execute();
    }

    public long deleteByAuthorizationCodeExpiresAt(LocalDateTime expiredTime) {
        return this.jpaQueryFactory.delete((EntityPath)QDO).where(new Predicate[]{OAuth2AuthenticationRepoProc.QDO.authorizationCodeExpiresAt.before((Comparable)expiredTime)}).execute();
    }

    public long deleteByOidcIdTokenExpiresAt(LocalDateTime expiredTime) {
        return this.jpaQueryFactory.delete((EntityPath)QDO).where(new Predicate[]{OAuth2AuthenticationRepoProc.QDO.oidcIdTokenExpiresAt.before((Comparable)expiredTime)}).execute();
    }

    public OAuth2AuthorizationDO getByToken(String token, OAuth2TokenType tokenType) {
        BooleanExpression predicate = null;
        if (tokenType == null) {
            predicate = OAuth2AuthenticationRepoProc.QDO.authorizationCodeValue.eq((Object)token).or((Predicate)OAuth2AuthenticationRepoProc.QDO.accessTokenValue.eq((Object)token)).or((Predicate)OAuth2AuthenticationRepoProc.QDO.refreshTokenValue.eq((Object)token)).or((Predicate)OAuth2AuthenticationRepoProc.QDO.oidcIdTokenValue.eq((Object)token));
        } else if ("state".equals(tokenType.getValue())) {
            predicate = OAuth2AuthenticationRepoProc.QDO.state.eq((Object)token);
        } else if ("code".equals(tokenType.getValue())) {
            predicate = OAuth2AuthenticationRepoProc.QDO.authorizationCodeValue.eq((Object)token);
        } else if (OAuth2TokenType.ACCESS_TOKEN.equals((Object)tokenType)) {
            predicate = OAuth2AuthenticationRepoProc.QDO.accessTokenValue.eq((Object)token);
        } else if (OAuth2TokenType.REFRESH_TOKEN.equals((Object)tokenType)) {
            predicate = OAuth2AuthenticationRepoProc.QDO.refreshTokenValue.eq((Object)token);
        }
        return (OAuth2AuthorizationDO)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)QDO).from((EntityPath)QDO)).where((Predicate)predicate)).limit(1L)).fetchOne();
    }
}

