/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.authorization.api.provider.web.controller;

import com.elitesland.cloudt.authorization.api.client.model.OAuthToken;
import com.elitesland.cloudt.authorization.api.provider.model.bo.OAuth2ClientConfigBO;
import com.elitesland.cloudt.authorization.api.provider.model.vo.resp.OAuth2SettingRespVO;
import com.elitesland.cloudt.authorization.api.provider.provider.oauth2.client.OAuth2ClientProvider;
import com.elitesland.yst.common.base.ApiResult;
import javax.validation.constraints.NotBlank;
import org.springframework.data.repository.query.Param;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@ResponseBody
@RequestMapping(value={"/oauth2/login"}, produces={"application/json"})
@Validated
public class OAuth2LoginSupportController {
    private final OAuth2ClientProvider oAuth2ClientProvider;

    public OAuth2LoginSupportController(OAuth2ClientProvider oAuth2ClientProvider) {
        this.oAuth2ClientProvider = oAuth2ClientProvider;
    }

    @GetMapping(value={"/setting"})
    public ApiResult<OAuth2SettingRespVO> getSetting() {
        OAuth2ClientConfigBO clientConfig = this.oAuth2ClientProvider.getoAuth2ClientConfigBO();
        if (clientConfig == null) {
            return ApiResult.fail((String)"\u672a\u521d\u59cb\u5316\u8ba4\u8bc1\u670d\u52a1\u7aef\u914d\u7f6e");
        }
        OAuth2SettingRespVO respVO = new OAuth2SettingRespVO();
        respVO.setClientId(clientConfig.getClientId());
        respVO.setAuthorizeEndpoint(clientConfig.getAuthorizeEndpoint());
        return ApiResult.ok((Object)respVO);
    }

    @GetMapping(value={"/code2token"})
    public ApiResult<OAuthToken> code2Token(@Param(value="clientId") @NotBlank(message="\u5ba2\u6237\u7aefID\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u5ba2\u6237\u7aefID\u4e0d\u80fd\u4e3a\u7a7a") String clientId, @Param(value="code") @NotBlank(message="\u6388\u6743\u7801\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u6388\u6743\u7801\u4e0d\u80fd\u4e3a\u7a7a") String code, @Param(value="redirectUri") @NotBlank(message="\u91cd\u5b9a\u5411\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u91cd\u5b9a\u5411\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a") String redirectUri, @Param(value="codeVerifier") String codeVerifier) {
        return this.oAuth2ClientProvider.code2AccessToken(clientId, code, redirectUri, codeVerifier);
    }
}

