package com.elitesland.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import java.io.Serial;
import java.io.Serializable;

/**
 * 组织(部门)新增参数.
 *
 * @author Kaiser（wang shao）
 * @date 2025/7/11 周日
 */
@ApiModel(description = "组织(部门)新增参数")
@Getter
@Setter
public class SysOrgAddDTO implements Serializable {
    @Serial
    private static final long serialVersionUID = -404415095692723969L;

    @ApiModelProperty(value = "组织编码", required = true)
    @NotBlank(message = "组织编码不能为空")
    private String code;

    @ApiModelProperty(value = "组织名称", required = true)
    @NotBlank(message = "组织名称不能为空")
    private String name;

    @ApiModelProperty(value = "上级组织编码, 默认取集团编码:NXG")
    private String parentCode;

    @ApiModelProperty(value = "简称")
    private String shortName;

    @ApiModelProperty(value = "组织类型，[UDC]cloudt-system:orgType, " +
            "默认为部门:DEPT")
    private String type;

    @ApiModelProperty(value = "是否启用，默认-true")
    private Boolean enabled;

    @ApiModelProperty(value = "是否为行政组织，默认:true")
    private Boolean executive;

    @ApiModelProperty(value = "是否为实体组织，默认:true")
    private Boolean entity;

    @ApiModelProperty(value = "财务成本中心编码")
    private String outerCode;

    @ApiModelProperty(value = "备注")
    private String remark;
}
