/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.cgb.toolkit;

import cfca.sadk.algorithm.common.CBCParam;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKCS7SignedData;
import cfca.sadk.algorithm.common.PKCS7SignedFile;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.util.SymmetricHelper;
import cfca.sadk.algorithm.util.SymmetricParams;
import cfca.sadk.envelope.EnvelopeEncryptHelper;
import cfca.sadk.lib.crypto.JCrypto;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.org.bouncycastle.asn1.ASN1OctetString;
import cfca.sadk.org.bouncycastle.asn1.ASN1Set;
import cfca.sadk.org.bouncycastle.asn1.DEROctetString;
import cfca.sadk.org.bouncycastle.asn1.cms.ContentInfo;
import cfca.sadk.org.bouncycastle.asn1.cms.EncryptedContentInfo;
import cfca.sadk.org.bouncycastle.asn1.cms.EnvelopedData;
import cfca.sadk.org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import cfca.sadk.org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import cfca.sadk.org.bouncycastle.asn1.cms.RecipientIdentifier;
import cfca.sadk.org.bouncycastle.asn1.cms.RecipientInfo;
import cfca.sadk.org.bouncycastle.asn1.x500.X500Name;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.org.bouncycastle.cms.CMSEnvelopedData;
import cfca.sadk.org.bouncycastle.cms.CMSException;
import cfca.sadk.org.bouncycastle.util.Strings;
import cfca.sadk.system.CompatibleAlgorithm;
import cfca.sadk.system.CompatibleConfig;
import cfca.sadk.system.FileHelper;
import cfca.sadk.system.Mechanisms;
import cfca.sadk.util.Base64;
import cfca.sadk.util.CertUtil;
import cfca.sadk.util.KeyUtil;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.PrivateKey;

public final class Castle {
    public static final int SIGN_FILE_SIZE = CompatibleConfig.FILEANDBUFFER_SIGNED_FILE_MAXSIZE;
    private static final String encoding = "UTF-16LE";
    private SignerAlgorithmParameters rsaParams = null;
    private SignerAlgorithmParameters sm2Params = null;
    private Session session = null;

    public Castle() throws PKIException {
        this("JSOFT_LIB");
    }

    public Castle(String deviceName) throws PKIException {
        String cryptoName = "JSOFT_LIB";
        if ("JNISOFT_LIB".equals(deviceName)) {
            cryptoName = "JNISOFT_LIB";
        }
        JCrypto.getInstance().initialize(cryptoName, null);
        this.session = JCrypto.getInstance().openSession(cryptoName);
    }

    public static final void setCompatibleSM2WithoutZ(boolean compatibleSM2WithoutZ) {
        CompatibleAlgorithm.setCompatibleSM2WithoutZ(compatibleSM2WithoutZ);
    }

    public void initCertAppContext(String pfxFilePath, String pfxFilePassword, String sm2FilePath, String sm2FilePassword) throws PKIException {
        X509Cert cert;
        PrivateKey privateKey;
        if (pfxFilePath != null) {
            privateKey = KeyUtil.getPrivateKeyFromPFX(pfxFilePath, pfxFilePassword);
            cert = CertUtil.getCertFromPFX(pfxFilePath, pfxFilePassword);
            this.rsaParams = new SignerAlgorithmParameters(cert, privateKey);
        }
        if (sm2FilePath != null) {
            privateKey = KeyUtil.getPrivateKeyFromSM2(sm2FilePath, sm2FilePassword);
            cert = CertUtil.getCertFromSM2(sm2FilePath);
            this.sm2Params = new SignerAlgorithmParameters(cert, privateKey);
        }
    }

    public String signData(String srcMessage) throws PKIException {
        return this.signedMessage(true, Mechanisms.M_SHA1_RSA, srcMessage);
    }

    public String signData(String signAlg, String srcMessage) throws PKIException {
        return this.signedMessage(true, this.mechanismFrom(signAlg), srcMessage);
    }

    private Mechanism mechanismFrom(String signAlg) {
        return Mechanisms.signMechanismFrom(signAlg);
    }

    public String signDataDetached(String srcMessage) throws PKIException {
        return this.signedMessage(false, Mechanisms.M_SHA1_RSA, srcMessage);
    }

    public String signDataDetached(String signAlg, String srcMessage) throws PKIException {
        return this.signedMessage(false, this.mechanismFrom(signAlg), srcMessage);
    }

    private final String signedMessage(boolean attached, Mechanism mechanism, String srcMessage) throws PKIException {
        if (mechanism == null) {
            throw new IllegalArgumentException("null not allowed for signAlg");
        }
        if (srcMessage == null) {
            throw new IllegalArgumentException("null not allowed for srcMessage");
        }
        SignerAlgorithmParameters params = this.buildAndCheckSignerAlgorithmParameters(mechanism);
        PKCS7SignedData p7 = new PKCS7SignedData(this.session);
        byte[] sourceData = null;
        byte[] signture = null;
        try {
            sourceData = srcMessage.getBytes(encoding);
            signture = this.session.sign(mechanism, params.privateKey, sourceData);
        }
        catch (PKIException e) {
            throw new PKIException(PKIException.SIGN_DES, "Failure on signedMessage", e);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.SIGN_DES, "Failure on signedMessage", e);
        }
        if (!attached) {
            sourceData = null;
        }
        try {
            return Strings.fromByteArray(Base64.encode(p7.packageSignedData(attached, null, sourceData, signture, mechanism, params.certs)));
        }
        catch (PKIException e) {
            throw new PKIException(PKIException.SIGN, "Failure on packageSignedData", e);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.SIGN, "Failure on packageSignedData", e);
        }
    }

    public String signFile(String srcFilePath) throws PKIException {
        return this.signedFile(true, Mechanisms.M_SHA1_RSA, srcFilePath);
    }

    public String signFile(String signAlg, String srcFilePath) throws PKIException {
        return this.signedFile(true, this.mechanismFrom(signAlg), srcFilePath);
    }

    public String signFileDetached(String srcFilePath) throws PKIException {
        return this.signedFile(false, Mechanisms.M_SHA1_RSA, srcFilePath);
    }

    public String signFileDetached(String signAlg, String srcFilePath) throws PKIException {
        return this.signedFile(false, this.mechanismFrom(signAlg), srcFilePath);
    }

    private final String signedFile(boolean attached, Mechanism mechanism, String srcFilePath) throws PKIException {
        if (mechanism == null) {
            throw new IllegalArgumentException("null not allowed for signAlg");
        }
        if (srcFilePath == null) {
            throw new IllegalArgumentException("null not allowed for srcFilePath");
        }
        SignerAlgorithmParameters params = this.buildAndCheckSignerAlgorithmParameters(mechanism);
        FileInputStream fis = null;
        byte[] signture = null;
        try {
            try {
                fis = new FileInputStream(srcFilePath);
                signture = this.session.sign(mechanism, params.privateKey, fis);
            }
            catch (PKIException e) {
                throw new PKIException(PKIException.SIGN_DES, "Failure on signedFile", e);
            }
            catch (Exception e) {
                throw new PKIException(PKIException.SIGN_DES, "Failure on signedFile", e);
            }
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            FileHelper.closedStream(fis, "signedFile closeFile failure");
            throw throwable;
        }
        FileHelper.closedStream(fis, "signedFile closeFile failure");
        if (attached) {
            PKCS7SignedFile p7 = new PKCS7SignedFile(this.session);
            String p7sFile = srcFilePath + ".p7s";
            try {
                p7.packageSignedFile(srcFilePath, p7sFile, signture, mechanism, params.certs);
            }
            catch (PKIException e) {
                throw new PKIException(PKIException.SIGN, "Failure on packageSignedFile", e);
            }
            catch (Exception e) {
                throw new PKIException(PKIException.SIGN, "Failure on packageSignedFile", e);
            }
            return p7sFile;
        }
        PKCS7SignedData p7 = new PKCS7SignedData(this.session);
        try {
            return Strings.fromByteArray(Base64.encode(p7.packageSignedData(false, null, null, signture, mechanism, params.certs)));
        }
        catch (PKIException e) {
            throw new PKIException(PKIException.SIGN, "Failure on packageSignedData", e);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.SIGN, "Failure on packageSignedData", e);
        }
    }

    public byte[] getCertificate(String base64SignedResult) throws PKIException {
        if (base64SignedResult == null) {
            throw new IllegalArgumentException("null not allowed for signedMessage");
        }
        PKCS7SignedData p7 = new PKCS7SignedData(this.session);
        p7.loadBase64(Strings.toByteArray(base64SignedResult));
        X509Cert cert = p7.getSignerX509Cert();
        if (cert == null) {
            throw new SecurityException("signed certificate not found");
        }
        return cert.getEncoding();
    }

    public String verifySignedData(String base64SignedResult) throws PKIException {
        return this.verifySignedMessage(base64SignedResult, null);
    }

    public boolean verifyDetachedSignedData(String base64SignedResult, String srcMessage) throws PKIException {
        byte[] message;
        if (srcMessage == null) {
            throw new IllegalArgumentException("null not allowed for srcMessage");
        }
        try {
            message = srcMessage.getBytes(encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new PKIException(PKIException.VERIFY_SIGN, "Failure on encoding sourceData", e);
        }
        return this.verifySignedMessage(base64SignedResult, message) != null;
    }

    public boolean verifyDetachedSignedDataAU(String base64SignedResult, String srcMessage) throws PKIException {
        byte[] message;
        if (srcMessage == null) {
            throw new IllegalArgumentException("null not allowed for srcMessage");
        }
        try {
            message = srcMessage.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new PKIException(PKIException.VERIFY_SIGN, "Failure on encoding sourceData", e);
        }
        return this.verifySignedMessage(base64SignedResult, message) != null;
    }

    private final String verifySignedMessage(String base64SignedResult, byte[] message) throws PKIException {
        if (base64SignedResult == null) {
            throw new IllegalArgumentException("null not allowed for signedMessage");
        }
        PKCS7SignedData p7 = new PKCS7SignedData(this.session);
        byte[] signData = Strings.toByteArray(base64SignedResult);
        try {
            p7.loadBase64(signData);
        }
        catch (PKIException e) {
            throw new PKIException(PKIException.VERIFY_SIGN, "Failure on loadSignedData", e);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.VERIFY_SIGN, "Failure on loadSignedData", e);
        }
        boolean verifyResult = false;
        if (message != null) {
            try {
                verifyResult = p7.verifyP7SignedData(message);
            }
            catch (PKIException e) {
                throw new PKIException(PKIException.VERIFY_SIGN_DES, "Failure on verifyP7SignedData", e);
            }
            catch (Exception e) {
                throw new PKIException(PKIException.VERIFY_SIGN_DES, "Failure on verifyP7SignedData", e);
            }
            if (verifyResult) {
                return "Okay";
            }
        } else {
            try {
                verifyResult = p7.verifyP7SignedDataAttach();
            }
            catch (PKIException e) {
                throw new PKIException(PKIException.VERIFY_SIGN_DES, "Failure on verifyP7SignedDataAttach", e);
            }
            catch (Exception e) {
                throw new PKIException(PKIException.VERIFY_SIGN_DES, "Failure on verifyP7SignedDataAttach", e);
            }
            if (verifyResult) {
                try {
                    return new String(p7.getSourceData(), encoding);
                }
                catch (UnsupportedEncodingException e) {
                    throw new PKIException(PKIException.VERIFY_SIGN, "Failure on encoding sourceData", e);
                }
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean verifySignedFile(String signedFilePath, String srcFilePath) throws PKIException {
        if (signedFilePath == null) {
            throw new IllegalArgumentException("null not allowed for signedFilePath");
        }
        File file = new File(signedFilePath);
        if (!file.exists()) {
            throw new SecurityException("signedFilePath invalid");
        }
        if (file.length() <= (long)SIGN_FILE_SIZE) {
            boolean verifyResult2;
            PKCS7SignedData p7 = new PKCS7SignedData(this.session);
            try {
                p7.loadBase64(FileHelper.read(signedFilePath));
            }
            catch (PKIException e) {
                throw new PKIException(PKIException.VERIFY_SIGN, "Failure on loadSignedData", e);
            }
            catch (Exception e) {
                throw new PKIException(PKIException.VERIFY_SIGN, "Failure on loadSignedData", e);
            }
            try {
                verifyResult2 = p7.verifyP7SignedDataAttach();
            }
            catch (PKIException e) {
                throw new PKIException(PKIException.VERIFY_SIGN_DES, "Failure on verifyP7SignedDataAttach", e);
            }
            catch (Exception e) {
                throw new PKIException(PKIException.VERIFY_SIGN_DES, "Failure on verifyP7SignedDataAttach", e);
            }
            if (!verifyResult2) return verifyResult2;
            if (srcFilePath == null) return verifyResult2;
            if (srcFilePath.trim().length() == 0) return verifyResult2;
            FileOutputStream fileIn = null;
            try {
                try {
                    fileIn = new FileOutputStream(srcFilePath);
                    FileHelper.writeBytesToFile(p7.getSourceData(), fileIn);
                }
                catch (FileNotFoundException e) {
                    throw new PKIException(PKIException.VERIFY_SIGN, "Failure on write srcFilePath", e);
                }
                catch (Exception e) {
                    throw new PKIException(PKIException.VERIFY_SIGN, "Failure on write srcFilePath", e);
                }
                Object var9_14 = null;
            }
            catch (Throwable throwable) {
                Object var9_15 = null;
                FileHelper.closedStream(fileIn, "verifySignedFile closedFile failed");
                throw throwable;
            }
            FileHelper.closedStream(fileIn, "verifySignedFile closedFile failed");
            return verifyResult2;
        }
        PKCS7SignedFile p7 = new PKCS7SignedFile(this.session);
        try {
            return p7.verifyP7SignedFile(signedFilePath, srcFilePath);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.VERIFY_SIGN_DES, "Failure on verifyP7SignedFile", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean verifyDetachedSignedFile(String base64SignedResult, String srcFilePath) throws PKIException {
        boolean bl;
        if (base64SignedResult == null) {
            throw new IllegalArgumentException("null not allowed for signedResult");
        }
        if (srcFilePath == null) {
            throw new IllegalArgumentException("null not allowed for srcFilePath");
        }
        PKCS7SignedData p7 = new PKCS7SignedData(this.session);
        try {
            p7.loadBase64(Strings.toByteArray(base64SignedResult));
        }
        catch (PKIException e) {
            throw new PKIException(PKIException.VERIFY_SIGN, "Failure on loadSignedData", e);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.VERIFY_SIGN, "Failure on loadSignedData", e);
        }
        FileInputStream fis = null;
        try {
            try {
                fis = new FileInputStream(srcFilePath);
                bl = p7.verifyP7SignedData(fis);
                Object var7_10 = null;
            }
            catch (PKIException e) {
                throw new PKIException(PKIException.VERIFY_SIGN_DES, "Failure on verifyP7SignedData", e);
            }
            catch (Exception e) {
                throw new PKIException(PKIException.VERIFY_SIGN_DES, "Failure on verifyP7SignedData", e);
            }
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            FileHelper.closedStream(fis, "verifyDetachedSignedFile closeFile failure");
            throw throwable;
        }
        FileHelper.closedStream(fis, "verifyDetachedSignedFile closeFile failure");
        return bl;
    }

    public String generateEnvelope(String srcMessage, String encryptAlg, byte[] certBytes) throws PKIException {
        if (srcMessage == null) {
            throw new IllegalArgumentException("null not allowed for srcMessage");
        }
        if (encryptAlg == null) {
            throw new IllegalArgumentException("null not allowed for encryptAlg");
        }
        if (certBytes == null) {
            throw new IllegalArgumentException("null not allowed for certBytes");
        }
        X509Cert encryptCert = null;
        X509Cert[] receiverCerts = null;
        boolean sm2Type = false;
        try {
            encryptCert = new X509Cert(certBytes);
            receiverCerts = new X509Cert[]{encryptCert};
            sm2Type = encryptCert.isSM2Cert();
        }
        catch (Exception e) {
            throw new PKIException(PKIException.ENCRYPT, "invalid encrypt certificate", e);
        }
        if (sm2Type) {
            if (!"SM4/CBC/PKCS7Padding".equals(encryptAlg) && !"SM4/ECB/PKCS7Padding".equals(encryptAlg)) {
                throw new PKIException(PKIException.NOT_SUP_DES + ",SM2 cert:" + encryptAlg);
            }
        } else if (!("DESede/CBC/PKCS7Padding".equals(encryptAlg) || "DESede/ECB/PKCS7Padding".equals(encryptAlg) || "RC4".equals(encryptAlg))) {
            throw new PKIException(PKIException.NOT_SUP_DES + ",RSA cert:" + encryptAlg);
        }
        try {
            boolean policy = false;
            EnvelopeEncryptHelper envelopeUtil = new EnvelopeEncryptHelper(sm2Type);
            return Strings.fromByteArray(envelopeUtil.envelopeMessage(srcMessage.getBytes(encoding), encryptAlg, receiverCerts, this.session, 0));
        }
        catch (UnsupportedEncodingException e) {
            throw new PKIException(PKIException.ENCRYPT_DES, "failure on envelopeMessage", e);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.ENCRYPT_DES, "failure on envelopeMessage", e);
        }
    }

    public String decodeEnvelope(String base64EnvelopedMessage) throws PKIException {
        CMSEnvelopedData cmsEnData;
        if (base64EnvelopedMessage == null) {
            throw new IllegalArgumentException("null not allowed for envelopedMessage");
        }
        try {
            cmsEnData = new CMSEnvelopedData(Base64.decode(base64EnvelopedMessage));
        }
        catch (CMSException e) {
            throw new PKIException(PKIException.DECRYPT, "load EnvelopedData failure", e);
        }
        try {
            ContentInfo info = cmsEnData.toASN1Structure();
            EnvelopedData enData = EnvelopedData.getInstance(info.getContent());
            ASN1Set receivers = enData.getRecipientInfos();
            EncryptedContentInfo data = enData.getEncryptedContentInfo();
            ASN1OctetString os = data.getEncryptedContent();
            AlgorithmIdentifier symmetricAlgId = data.getContentEncryptionAlgorithm();
            Mechanism mechanism = this.buildMechanism(symmetricAlgId);
            boolean isSM2Type = mechanism.getMechanismType().indexOf("SM4") >= 0;
            byte[] symmetricKey = this.decodedSymmetricKey(isSM2Type, receivers);
            boolean jniFlag = this.session != null && this.session.useJniNativeOperation();
            byte[] encryptedData = os.getOctets();
            byte[] decryptedData = SymmetricHelper.dataDecrypt(jniFlag, mechanism, symmetricKey, encryptedData);
            return new String(decryptedData, encoding);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PKIException("850935", "\u89e3\u6790\u6d88\u606f\u6570\u5b57\u4fe1\u5c01\u5931\u8d25", e);
        }
    }

    private final byte[] decodedSymmetricKey(boolean isSM2Type, ASN1Set receivers) throws PKIException {
        SignerAlgorithmParameters params;
        SignerAlgorithmParameters signerAlgorithmParameters = params = isSM2Type ? this.sm2Params : this.rsaParams;
        if (params == null) {
            throw new PKIException("recipient' certificate/privatekey not  initial");
        }
        X500Name recipientIssuer = params.cert.getIssuerX500Name();
        BigInteger recipientSN = params.cert.getSerialNumber();
        byte[] subjectPubKeyID = params.cert.getSubjectKeyIdentifier().getKeyIdentifier();
        if (receivers == null) {
            throw new PKIException("the receiver is null!!!");
        }
        ASN1OctetString encryptKey = null;
        int len = receivers.size();
        for (int i = 0; i < len; ++i) {
            KeyTransRecipientInfo inf;
            RecipientInfo recip = RecipientInfo.getInstance(receivers.getObjectAt(i));
            if (!(recip.getInfo() instanceof KeyTransRecipientInfo) || !Castle.hasRecipent(inf = KeyTransRecipientInfo.getInstance(recip.getInfo()), subjectPubKeyID, recipientIssuer, recipientSN)) continue;
            encryptKey = inf.getEncryptedKey();
            break;
        }
        if (encryptKey == null) {
            throw new PKIException("can not find the receiver!!!");
        }
        Mechanism contentEncryptionAlg = isSM2Type ? new Mechanism("SM2") : new Mechanism("RSA/ECB/PKCS1PADDING");
        return this.session.decrypt(contentEncryptionAlg, params.privateKey, encryptKey.getOctets());
    }

    private static boolean hasRecipent(KeyTransRecipientInfo inf, byte[] subjectPubKeyID, X500Name recipientIssuer, BigInteger recipientSN) {
        RecipientIdentifier id = inf.getRecipientIdentifier();
        DEROctetString oct = new DEROctetString(subjectPubKeyID);
        IssuerAndSerialNumber issu = new IssuerAndSerialNumber(recipientIssuer, recipientSN);
        return id.getId().toASN1Primitive().asn1Equals(oct) || id.getId().toASN1Primitive().asn1Equals(issu.toASN1Primitive());
    }

    private final Mechanism buildMechanism(AlgorithmIdentifier symmetricAlgId) throws PKIException {
        if (symmetricAlgId == null || symmetricAlgId.getAlgorithm() == null) {
            throw new PKIException(PKIException.UNSUPPORT_ENCRYPT_ALG_SIGNANDENVELOP_ERR, "invalid AlgorithmIdentifier");
        }
        String encryptionAlgorithm = SymmetricParams.getSymmetricAlgorithmName(symmetricAlgId.getAlgorithm());
        if (encryptionAlgorithm == null) {
            throw new PKIException(PKIException.UNSUPPORT_ENCRYPT_ALG_SIGNANDENVELOP_ERR, "invalid AlgorithmIdentifier: " + symmetricAlgId.getAlgorithm());
        }
        Mechanism mechanism = null;
        if (encryptionAlgorithm.indexOf("CBC") != -1) {
            DEROctetString doct = (DEROctetString)symmetricAlgId.getParameters();
            if (doct == null || doct.getOctets() == null) {
                throw new PKIException(PKIException.UNSUPPORT_ENCRYPT_ALG_SIGNANDENVELOP_ERR, "missing cbc-param");
            }
            CBCParam cbcParam = new CBCParam(doct.getOctets());
            if (encryptionAlgorithm.equals("DESede/CBC/PKCS7Padding")) {
                mechanism = new Mechanism("DESede/CBC/PKCS7Padding", cbcParam);
            } else if (encryptionAlgorithm.equals("SM4/CBC/PKCS7Padding")) {
                mechanism = new Mechanism("SM4/CBC/PKCS7Padding", cbcParam);
            }
        } else if (encryptionAlgorithm.indexOf("ECB") != -1) {
            if (encryptionAlgorithm.equals("DESede/ECB/PKCS7Padding")) {
                mechanism = new Mechanism("DESede/ECB/PKCS7Padding");
            } else if (encryptionAlgorithm.equals("SM4/ECB/PKCS7Padding")) {
                mechanism = new Mechanism("SM4/ECB/PKCS7Padding");
            }
        } else if (encryptionAlgorithm.indexOf("RC4") != -1) {
            mechanism = new Mechanism("RC4");
        }
        if (mechanism == null) {
            throw new PKIException(PKIException.UNSUPPORT_ENCRYPT_ALG_SIGNANDENVELOP_ERR, PKIException.UNSUPPORT_ENCRYPT_ALG_SIGNANDENVELOP_ERR_DES + "Algorithm is:" + encryptionAlgorithm);
        }
        return mechanism;
    }

    private final SignerAlgorithmParameters buildAndCheckSignerAlgorithmParameters(Mechanism signAlg) throws PKIException {
        if (!Mechanism.isValid(signAlg)) {
            throw new PKIException(PKIException.SIGN, PKIException.SIGN_DES + " " + PKIException.NOT_SUP_DES + " " + signAlg);
        }
        SignerAlgorithmParameters params = null;
        if (Mechanisms.isSM2WithSM3(signAlg)) {
            if (this.sm2Params == null) {
                throw new PKIException(PKIException.SIGN, "null not allowed for sm2Cert/sm2PriKey when signAlg as " + signAlg);
            }
            params = this.sm2Params;
        } else {
            if (this.rsaParams == null) {
                throw new PKIException(PKIException.SIGN, "null not allowed for rsaCert/rsaPriKey when signAlg as " + signAlg);
            }
            params = this.rsaParams;
        }
        return params;
    }

    static final class SignerAlgorithmParameters {
        final PrivateKey privateKey;
        final X509Cert[] certs;
        final X509Cert cert;

        SignerAlgorithmParameters(X509Cert cert, PrivateKey privateKey) {
            this.cert = cert;
            this.certs = new X509Cert[]{cert};
            this.privateKey = privateKey;
        }
    }
}

