/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.envelope;

import cfca.sadk.algorithm.common.CBCParam;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.util.SymmetricHelper;
import cfca.sadk.algorithm.util.SymmetricParams;
import cfca.sadk.asn1.parser.ASN1Node;
import cfca.sadk.asn1.parser.EnvelopFileParser;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.org.bouncycastle.asn1.ASN1Encodable;
import cfca.sadk.org.bouncycastle.asn1.ASN1OctetString;
import cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import cfca.sadk.org.bouncycastle.asn1.ASN1Set;
import cfca.sadk.org.bouncycastle.asn1.DEROctetString;
import cfca.sadk.org.bouncycastle.asn1.cms.ContentInfo;
import cfca.sadk.org.bouncycastle.asn1.cms.EncryptedContentInfo;
import cfca.sadk.org.bouncycastle.asn1.cms.EnvelopedData;
import cfca.sadk.org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import cfca.sadk.org.bouncycastle.asn1.cms.RecipientInfo;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.org.bouncycastle.cms.CMSEnvelopedData;
import cfca.sadk.system.SADKDebugger;
import cfca.sadk.system.logging.LoggerManager;
import cfca.sadk.util.Base64;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.security.PrivateKey;
import java.util.ArrayList;

public final class EnvelopeDecryptHelper {
    public static final boolean openEnvelopedFile(String inEnvelopedFilePath, String outSourceFilePath, PrivateKey recipientPrivateKey, X509Cert recipientCert, Session session) throws PKIException {
        EnvelopFileParser parser;
        if (inEnvelopedFilePath == null) {
            throw new PKIException("openEnvelopedFile failed: missing inEnvelopedFilePath");
        }
        if (outSourceFilePath == null) {
            throw new PKIException("openEnvelopedFile failed: missing outSourceFilePath");
        }
        if (recipientPrivateKey == null) {
            throw new PKIException("openEnvelopedFile failed: missing recipientPrivateKey");
        }
        if (recipientCert == null) {
            throw new PKIException("openEnvelopedFile failed: missing recipientCert");
        }
        if (session == null) {
            throw new PKIException("openEnvelopedFile failed: missing session");
        }
        try {
            parser = new EnvelopFileParser(new File(inEnvelopedFilePath));
            parser.parser();
        }
        catch (Exception e) {
            throw new PKIException("openEnvelopedFile failed: @parsed EnvelopFile failed", e);
        }
        ASN1Node recipientNode = parser.getReceiver_node();
        if (recipientNode == null) {
            throw new PKIException("openEnvelopedFile failed: missing recipientNode");
        }
        ASN1Node encryptedNode = parser.getEncrypted_node();
        if (encryptedNode == null) {
            throw new PKIException("openEnvelopedFile failed: missing encryptedNode");
        }
        ArrayList encryptedChildNodes = encryptedNode.childNodes;
        if (encryptedChildNodes == null) {
            throw new PKIException("openEnvelopedFile failed: missing encryptedChildNodes");
        }
        if (encryptedChildNodes.size() < 3) {
            throw new PKIException("openEnvelopedFile failed: encryptedChildNodes less 3-node");
        }
        try {
            ASN1Node symmetricEncryptedAlgorithmNode = (ASN1Node)encryptedNode.childNodes.get(1);
            ASN1Node symmetricEncryptedContextNode = (ASN1Node)encryptedNode.childNodes.get(2);
            byte[] symmetricKey = EnvelopeDecryptHelper.decryptRecipientKey(recipientPrivateKey, recipientCert, recipientNode, session);
            SymmetricParams mechanismKey = EnvelopeDecryptHelper.buildSymmetricEncryptedType(symmetricEncryptedAlgorithmNode, symmetricKey);
            return EnvelopeDecryptHelper.decryptedContext(mechanismKey, symmetricEncryptedContextNode, outSourceFilePath, session);
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PKIException("openEnvelopedFile failed: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            throw new PKIException("openEnvelopedFile failed: " + e.getMessage(), e);
        }
    }

    public static final byte[] openEnvelopedMessage(byte[] base64EnvelopeMessage, PrivateKey recipientPrivateKey, X509Cert recipientCert, Session session) throws PKIException {
        EnvelopedData enData;
        if (base64EnvelopeMessage == null) {
            throw new PKIException("openEnvelopedMessage failed: missing base64EnvelopeMessage");
        }
        if (recipientPrivateKey == null) {
            throw new PKIException("openEnvelopedMessage failed: missing recipientPrivateKey");
        }
        if (recipientCert == null) {
            throw new PKIException("openEnvelopedMessage failed: missing recipientCert");
        }
        if (session == null) {
            throw new PKIException("openEnvelopedMessage failed: missing session");
        }
        byte[] bEnvelop = null;
        try {
            bEnvelop = Base64.decode(base64EnvelopeMessage);
        }
        catch (Exception e) {
            throw new PKIException("openEnvelopedMessage failed: @Base64EnvelopedMessage decode failed!", e);
        }
        try {
            CMSEnvelopedData cmsEnData = new CMSEnvelopedData(bEnvelop);
            ContentInfo info = cmsEnData.toASN1Structure();
            enData = EnvelopedData.getInstance(info.getContent());
        }
        catch (Exception e) {
            throw new PKIException("openEnvelopedMessage failed: @EnvelopedData decode failed!", e);
        }
        try {
            ASN1Set receivers = enData.getRecipientInfos();
            byte[] symmetricKey = EnvelopeDecryptHelper.decryptRecipientKey(recipientPrivateKey, recipientCert, receivers, session);
            EncryptedContentInfo data = enData.getEncryptedContentInfo();
            ASN1OctetString os = data.getEncryptedContent();
            AlgorithmIdentifier symmetricAlgId = data.getContentEncryptionAlgorithm();
            SymmetricParams mechanismKey = EnvelopeDecryptHelper.buildSymmetricEncryptedType(symmetricAlgId, symmetricKey);
            byte[] symmetricEncryptedContextBytes = os.getOctets();
            byte[] sourceData = EnvelopeDecryptHelper.decryptedContext(mechanismKey, symmetricEncryptedContextBytes, session);
            return sourceData;
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PKIException("openEnvelopedMessage failed: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            throw new PKIException("openEnvelopedMessage failed: " + e.getMessage(), e);
        }
    }

    private static final byte[] decryptRecipientKey(PrivateKey recipientPrivateKey, X509Cert recipientCert, ASN1Set receivers, Session session) throws PKIException {
        byte[] symmetricKey;
        if (recipientPrivateKey == null) {
            throw new PKIException("openEnvelopedFailed@decryptRecipientKey->required recipientPrivateKey not null");
        }
        if (recipientCert == null) {
            throw new PKIException("openEnvelopedFailed@decryptRecipientKey->required recipientCert not null");
        }
        if (receivers == null) {
            throw new PKIException("openEnvelopedFailed@decryptRecipientKey->required receivers not null");
        }
        if (session == null) {
            throw new PKIException("openEnvelopedFailed@decryptRecipientKey->required session not null");
        }
        String certSN = recipientCert.getStringSerialNumber();
        ASN1OctetString encryptedKey = null;
        AlgorithmIdentifier keyEncryptionAlgorithm = null;
        try {
            int size = receivers.size();
            for (int i = 0; i < size; ++i) {
                KeyTransRecipientInfo inf;
                RecipientInfo recip = RecipientInfo.getInstance(receivers.getObjectAt(i));
                if (!(recip.getInfo() instanceof KeyTransRecipientInfo) || !recipientCert.isRecipent(inf = KeyTransRecipientInfo.getInstance(recip.getInfo()))) continue;
                encryptedKey = inf.getEncryptedKey();
                keyEncryptionAlgorithm = inf.getKeyEncryptionAlgorithm();
                break;
            }
        }
        catch (Exception e) {
            throw new PKIException("openEnvelopedFailed@decryptRecipientKey->find the receiver failed for certSN=" + certSN, e);
        }
        if (encryptedKey == null || keyEncryptionAlgorithm == null) {
            LoggerManager.exceptionLogger.error("openEnvelopedFailed@decryptRecipientKey->not find the receiver for certSN={}, encryptedKey={},keyEncryptionAlgorithm={}", new Object[]{certSN, encryptedKey, keyEncryptionAlgorithm});
            throw new PKIException("openEnvelopedFailed@decryptRecipientKey-> not find the receiver for certSN=" + certSN);
        }
        Mechanism contentEncryptionAlg = recipientCert.isSM2Cert() ? new Mechanism("SM2") : new Mechanism("RSA/ECB/PKCS1PADDING");
        try {
            symmetricKey = session.decrypt(contentEncryptionAlg, recipientPrivateKey, encryptedKey.getOctets());
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("openEnvelopedFailed@decryptRecipientKey->open(decrypt) failed for certSN={}, contentEncryptionAlg={},encryptedKey={}", new Object[]{certSN, contentEncryptionAlg, SADKDebugger.dump(encryptedKey.getOctets())});
            throw new PKIException("openEnvelopedFailed@decryptRecipientKey->open(decrypt) failed for certSN=" + certSN, e);
        }
        return symmetricKey;
    }

    private static final byte[] decryptRecipientKey(PrivateKey recipientPrivateKey, X509Cert recipientCert, ASN1Node recipientNode, Session session) throws PKIException {
        ASN1Set receivers;
        if (recipientNode == null) {
            throw new PKIException("openEnvelopedFailed@decryptRecipientKey->required recipientNode not null");
        }
        try {
            receivers = ASN1Set.getInstance(recipientNode.getData());
        }
        catch (Exception e) {
            throw new PKIException("openEnvelopedFailed@decryptRecipientKey->decoded recipientNode failed!", e);
        }
        return EnvelopeDecryptHelper.decryptRecipientKey(recipientPrivateKey, recipientCert, receivers, session);
    }

    private static final SymmetricParams buildSymmetricEncryptedType(AlgorithmIdentifier symmetricEncryptedAlgorithm, byte[] symmetricKey) throws PKIException {
        if (symmetricEncryptedAlgorithm == null) {
            throw new PKIException("openEnvelopedFailed@buildSymmetricEncryptedType->required symmetricEncryptedAlgorithm not null");
        }
        if (symmetricKey == null) {
            throw new PKIException("openEnvelopedFailed@buildSymmetricEncryptedType->required symmetricKey not null");
        }
        String encryptionType = SymmetricParams.getSymmetricAlgorithmName(symmetricEncryptedAlgorithm.getAlgorithm());
        if (encryptionType == null) {
            throw new PKIException("openEnvelopedFailed@buildSymmetricEncryptedType->do not support symmetricEncryptedAlgorithmOID=" + symmetricEncryptedAlgorithm.getAlgorithm());
        }
        byte[] iv = null;
        ASN1Encodable param = symmetricEncryptedAlgorithm.getParameters();
        if (param != null && param instanceof DEROctetString) {
            DEROctetString doct = (DEROctetString)param;
            iv = doct.getOctets();
        }
        return new SymmetricParams(encryptionType, symmetricKey, iv);
    }

    private static final SymmetricParams buildSymmetricEncryptedType(ASN1Node symmetricEncryptedAlgorithmNode, byte[] symmetricKey) throws PKIException {
        AlgorithmIdentifier symmetricEncryptedAlgorithm;
        if (symmetricEncryptedAlgorithmNode == null) {
            throw new PKIException("openEnvelopedFailed@buildSymmetricEncryptedType->required symmetricEncryptedAlgorithmNode not null");
        }
        try {
            byte[] symmetricAlgBytes = symmetricEncryptedAlgorithmNode.getData();
            symmetricEncryptedAlgorithm = AlgorithmIdentifier.getInstance(ASN1Sequence.getInstance(symmetricAlgBytes));
        }
        catch (Exception e) {
            throw new PKIException("openEnvelopedFailed@buildSymmetricEncryptedType->decoded symmetricEncryptedAlgorithm failed!", e);
        }
        return EnvelopeDecryptHelper.buildSymmetricEncryptedType(symmetricEncryptedAlgorithm, symmetricKey);
    }

    private static byte[] decryptedContext(SymmetricParams mechanismKey, byte[] symmetricEncryptedContextBytes, Session session) throws PKIException {
        if (mechanismKey == null) {
            throw new PKIException("openEnvelopedFailed@decryptedContext->required mechanismKey not null!");
        }
        if (mechanismKey.mechanismType == null) {
            throw new PKIException("openEnvelopedFailed@decryptedContext->required mechanismType not null!");
        }
        if (mechanismKey.symmetricKey == null) {
            throw new PKIException("openEnvelopedFailed@decryptedContext->required symmetricKey not null!");
        }
        String mechanismType = mechanismKey.mechanismType;
        byte[] symmetricKey = mechanismKey.symmetricKey;
        byte[] iv = mechanismKey.iv;
        boolean forJNILib = session != null && session.useJniNativeOperation();
        Mechanism mechanism = new Mechanism(mechanismType, new CBCParam(iv));
        byte[] sourceData = null;
        try {
            sourceData = SymmetricHelper.dataDecrypt(forJNILib, mechanism, symmetricKey, symmetricEncryptedContextBytes);
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("openEnvelopedFailed@decryptedContext symmetricDecryptFailed: forJNILib={},mechanism={},symmetricKey={},symmetricEncryptedContextBytes={}", new Object[]{forJNILib, mechanism, SADKDebugger.dump(symmetricKey), SADKDebugger.dump(symmetricEncryptedContextBytes), e});
            throw new PKIException("openEnvelopedFailed@decryptedContext symmetricDecryptFailed", e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("openEnvelopedFailed@decryptedContext symmetricDecryptFailed: forJNILib={},mechanism={},symmetricKey={},symmetricEncryptedContextBytes={}", new Object[]{forJNILib, mechanism, SADKDebugger.dump(symmetricKey), SADKDebugger.dump(symmetricEncryptedContextBytes), e});
            throw new PKIException("openEnvelopedFailed@decryptedContext symmetricDecryptFailed", e);
        }
        return sourceData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean decryptedContext(SymmetricParams mechanismKey, ASN1Node symmetricEncryptedContextNode, String outPlainFilePath, Session session) throws PKIException {
        boolean sourceEncryptFile2;
        File file;
        if (mechanismKey == null) {
            throw new PKIException("openEnvelopedFailed@decryptedContext->required mechanismKey not null!");
        }
        if (mechanismKey.mechanismType == null) {
            throw new PKIException("openEnvelopedFailed@decryptedContext->required mechanismType not null!");
        }
        if (mechanismKey.symmetricKey == null) {
            throw new PKIException("openEnvelopedFailed@decryptedContext->required symmetricKey not null!");
        }
        String mechanismType = mechanismKey.mechanismType;
        int nidType = mechanismKey.nidType;
        boolean forJNILib = session != null && session.useJniNativeOperation();
        try {
            file = new File(outPlainFilePath);
            if (!file.exists()) {
                file.createNewFile();
            }
        }
        catch (IOException e) {
            throw new PKIException("openEnvelopedFailed@decryptedContext->createNewFile for outPlainFilePath failed!", e);
        }
        FileOutputStream outputStream = null;
        try {
            try {
                block41: {
                    outputStream = new FileOutputStream(file);
                    if (symmetricEncryptedContextNode.childNodes.size() < 2) {
                        if (symmetricEncryptedContextNode.childNodes.size() == 1) {
                            symmetricEncryptedContextNode = (ASN1Node)symmetricEncryptedContextNode.childNodes.get(0);
                        }
                        if (forJNILib && nidType != 0) {
                            forJNILib = true;
                        } else if ("RC4".equals(mechanismType)) {
                            forJNILib = false;
                        } else if ("SM4/CBC/PKCS7Padding".equals(mechanismType) || "SM4/ECB/PKCS7Padding".equals(mechanismType)) {
                            forJNILib = false;
                        } else if ("DESede/CBC/PKCS7Padding".equals(mechanismType) || "DESede/ECB/PKCS7Padding".equals(mechanismType)) {
                            forJNILib = false;
                        } else {
                            if (!"AES/CBC/PKCS7Padding".equals(mechanismType)) {
                                if (!"AES/ECB/PKCS7Padding".equals(mechanismType)) throw new PKIException("@decryptedContext->not supported mechanismType: " + mechanismType);
                            }
                            forJNILib = false;
                        }
                        SymmetricHelper.fileDecrypt(forJNILib, mechanismKey, symmetricEncryptedContextNode, (OutputStream)outputStream);
                    } else {
                        RandomAccessFile sourceEncryptFile2 = null;
                        try {
                            sourceEncryptFile2 = new RandomAccessFile(symmetricEncryptedContextNode.f, "r");
                            if (forJNILib && nidType != 0) {
                                forJNILib = true;
                            } else if ("RC4".equals(mechanismType)) {
                                forJNILib = false;
                            } else if ("DESede/CBC/PKCS7Padding".equals(mechanismType) || "DESede/ECB/PKCS7Padding".equals(mechanismType)) {
                                forJNILib = false;
                            } else {
                                if (!"AES/CBC/PKCS7Padding".equals(mechanismType)) {
                                    if (!"AES/ECB/PKCS7Padding".equals(mechanismType)) throw new PKIException("openEnvelopedFailed@decryptedContext->not supported mechanismType: " + mechanismType);
                                }
                                forJNILib = false;
                            }
                            SymmetricHelper.fileDecrypt(forJNILib, mechanismKey, symmetricEncryptedContextNode, outputStream, sourceEncryptFile2);
                            Object var11_16 = null;
                            if (sourceEncryptFile2 == null) break block41;
                        }
                        catch (Throwable throwable) {
                            Object var11_17 = null;
                            if (sourceEncryptFile2 == null) throw throwable;
                            try {
                                sourceEncryptFile2.close();
                                throw throwable;
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                        try {}
                        catch (IOException e) {}
                        sourceEncryptFile2.close();
                    }
                }
                sourceEncryptFile2 = true;
                Object var14_21 = null;
                if (outputStream == null) return sourceEncryptFile2;
            }
            catch (FileNotFoundException e) {
                throw new PKIException("openEnvelopedFailed@decryptedContext->" + e.getMessage(), e);
            }
            catch (PKIException e) {
                throw new PKIException("openEnvelopedFailed@decryptedContext->" + e.getMessage(), e);
            }
            catch (Exception e) {
                throw new PKIException("openEnvelopedFailed@decryptedContext->" + e.getMessage(), e);
            }
            catch (Throwable e) {
                throw new PKIException("openEnvelopedFailed@decryptedContext->" + e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var14_22 = null;
            if (outputStream == null) throw throwable;
            try {
                outputStream.close();
                throw throwable;
            }
            catch (IOException e) {
                throw throwable;
            }
        }
        try {}
        catch (IOException e) {
            // empty catch block
            return sourceEncryptFile2;
        }
        outputStream.close();
        return sourceEncryptFile2;
    }
}

