/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.extend.session.bridge.impl.ecc;

import cfca.sadk.extend.session.CryptoException;
import cfca.sadk.org.bouncycastle.crypto.params.ECDomainParameters;
import cfca.sadk.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import cfca.sadk.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import cfca.sadk.org.bouncycastle.jce.interfaces.ECKey;
import cfca.sadk.org.bouncycastle.jce.spec.ECParameterSpec;

public final class ECCCardCurveHelper {
    private ECCCardCurveHelper() {
    }

    static final int bitLength(ECDomainParameters ecParams) {
        if (ecParams == null) {
            throw new IllegalArgumentException("bitLength build: domain-params is null");
        }
        if (ecParams.getN() == null) {
            throw new IllegalArgumentException("bitLength build: domain-params#N is null");
        }
        return ecParams.getN().bitLength();
    }

    static final int bitLength(ECParameterSpec ecParamSpec) {
        if (ecParamSpec == null) {
            throw new IllegalArgumentException("bitLength build: ECParameterSpec is null");
        }
        if (ecParamSpec.getN() == null) {
            throw new IllegalArgumentException("bitLength build: ECParameterSpec#N is null");
        }
        return ecParamSpec.getN().bitLength();
    }

    static final ECParameterSpec buildECParameterSpec(int curveI) throws CryptoException {
        return null;
    }

    static final ECParameterSpec buildECParameterSpec(ECPublicKeyParameters ecPubKeyParams) {
        if (ecPubKeyParams == null) {
            throw new IllegalArgumentException("buildECParameterSpec build: ecPubKeyParams is null");
        }
        return ECCCardCurveHelper.buildECParameterSpec(ecPubKeyParams.getParameters());
    }

    static final ECParameterSpec buildECParameterSpec(ECPrivateKeyParameters ecPriKeyParams) {
        if (ecPriKeyParams == null) {
            throw new IllegalArgumentException("buildECParameterSpec build: ecPriKeyParams is null");
        }
        return ECCCardCurveHelper.buildECParameterSpec(ecPriKeyParams.getParameters());
    }

    static final ECParameterSpec buildECParameterSpec(ECDomainParameters ecParams) {
        if (ecParams == null) {
            throw new IllegalArgumentException("buildECParameterSpec build: domain-params is null");
        }
        return new ECParameterSpec(ecParams.getCurve(), ecParams.getG(), ecParams.getN(), ecParams.getH(), ecParams.getSeed());
    }

    static final ECDomainParameters buildECDomainParameters(ECParameterSpec ecParamSpec) {
        if (ecParamSpec == null) {
            throw new IllegalArgumentException("buildECDomainParameters build: ecParamSpec is null");
        }
        return new ECDomainParameters(ecParamSpec.getCurve(), ecParamSpec.getG(), ecParamSpec.getN(), ecParamSpec.getH(), ecParamSpec.getSeed());
    }

    static final int getCurveId(ECKey cardKey) throws CryptoException {
        return cardKey == null ? -1 : 0;
    }

    static final int getCurveId(String curveOid) throws CryptoException {
        return curveOid == null ? -1 : 0;
    }

    static final int getCurveId(ECDomainParameters ecParams) throws CryptoException {
        return ecParams == null ? -1 : 0;
    }

    static final int getCurveId(ECParameterSpec ecParamSpec) throws CryptoException {
        return ecParamSpec == null ? -1 : 0;
    }
}

