/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm;

import cfca.sadk.org.bouncycastle.crypto.DerivationFunction;
import cfca.sadk.org.bouncycastle.crypto.agreement.SM2MQVBasicAgreement;
import cfca.sadk.org.bouncycastle.crypto.digests.SM3Digest;
import cfca.sadk.org.bouncycastle.crypto.generators.KDF2BytesGenerator;
import cfca.sadk.org.bouncycastle.crypto.params.ECDomainParameters;
import cfca.sadk.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import cfca.sadk.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import cfca.sadk.org.bouncycastle.crypto.params.KDFParameters;
import cfca.sadk.org.bouncycastle.crypto.params.MQVPrivateParameters;
import cfca.sadk.org.bouncycastle.crypto.params.MQVPublicParameters;
import cfca.sadk.org.bouncycastle.gmt.GMTObjectIdentifiers;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.SM2DHAlgorithmParameter;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.SM2Params;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import cfca.sadk.org.bouncycastle.jce.interfaces.MQVPrivateKey;
import cfca.sadk.org.bouncycastle.jce.interfaces.MQVPublicKey;
import cfca.sadk.org.bouncycastle.math.ec.ECPoint;
import cfca.sadk.org.bouncycastle.util.Integers;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;

public class KeyAgreementSpi
extends javax.crypto.KeyAgreementSpi {
    private static final Map algorithms = new HashMap();
    private String kaAlgorithm;
    private SM2DHAlgorithmParameter zParams = null;
    private ECDomainParameters parameters;
    private SM2MQVBasicAgreement agreement;
    private DerivationFunction kdf;
    private ECPoint result;

    protected KeyAgreementSpi(String kaAlgorithm, SM2MQVBasicAgreement agreement, DerivationFunction kdf) {
        this.kaAlgorithm = kaAlgorithm;
        this.agreement = agreement;
        this.kdf = kdf;
    }

    protected Key engineDoPhase(Key key, boolean lastPhase) throws InvalidKeyException, IllegalStateException {
        if (this.parameters == null) {
            throw new IllegalStateException(this.kaAlgorithm + " parameters not initialised.");
        }
        if (this.zParams == null) {
            throw new IllegalStateException(this.kaAlgorithm + " zParams not initialised.");
        }
        if (!lastPhase) {
            throw new IllegalStateException(this.kaAlgorithm + " can only be between two parties.");
        }
        if (!(key instanceof MQVPublicKey)) {
            throw new InvalidKeyException(this.kaAlgorithm + " key agreement requires " + KeyAgreementSpi.getSimpleName(MQVPublicKey.class) + " for doPhase");
        }
        MQVPublicKey mqvPubKey = (MQVPublicKey)key;
        ECPublicKeyParameters staticKey = (ECPublicKeyParameters)ECUtil.generatePublicKeyParameter(mqvPubKey.getStaticKey());
        ECPublicKeyParameters ephemKey = (ECPublicKeyParameters)ECUtil.generatePublicKeyParameter(mqvPubKey.getEphemeralKey());
        MQVPublicParameters pubKey = new MQVPublicParameters(staticKey, ephemKey);
        this.result = this.agreement.calculateMqvAgreement(pubKey);
        return null;
    }

    private void engineGenerateBytes(byte[] secret, int offset, int length) {
        if (secret == null) {
            throw new IllegalArgumentException(this.kaAlgorithm + " key agreement: secret null");
        }
        if (secret.length < offset + length) {
            throw new IllegalArgumentException(this.kaAlgorithm + " key agreement: secret shortage for save " + secret.length + " bytes");
        }
        byte[] agreementBytes = this.agreement.getAgreementBytes(this.result);
        byte[] ZBytes = this.zParams.getZBytes();
        byte[] seed = SM2Params.concat(agreementBytes, ZBytes);
        this.kdf.init(new KDFParameters(seed, new byte[0]));
        this.kdf.generateBytes(secret, offset, length);
    }

    protected byte[] engineGenerateSecret() throws IllegalStateException {
        byte[] secure = new byte[32];
        this.engineGenerateBytes(secure, 0, secure.length);
        return secure;
    }

    protected int engineGenerateSecret(byte[] sharedSecret, int offset) throws IllegalStateException, ShortBufferException {
        if (sharedSecret.length - offset <= 0) {
            throw new IllegalArgumentException(this.kaAlgorithm + " key agreement: secret shortage for save bytes");
        }
        int length = sharedSecret.length - offset;
        this.engineGenerateBytes(sharedSecret, offset, length);
        return length;
    }

    protected SecretKey engineGenerateSecret(String algorithm) throws NoSuchAlgorithmException {
        if (!algorithms.containsKey(algorithm)) {
            throw new NoSuchAlgorithmException("unknown algorithm encountered: " + algorithm);
        }
        int keySize = (Integer)algorithms.get(algorithm);
        byte[] secret = new byte[keySize / 8];
        this.engineGenerateBytes(secret, 0, secret.length);
        return new SecretKeySpec(secret, algorithm);
    }

    protected void engineInit(Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (params == null || !(params instanceof SM2DHAlgorithmParameter)) {
            throw new InvalidKeyException(this.kaAlgorithm + " key agreement requires " + KeyAgreementSpi.getSimpleName(SM2DHAlgorithmParameter.class) + " for initialisation");
        }
        this.zParams = (SM2DHAlgorithmParameter)params;
        this.initFromKey(key);
    }

    protected void engineInit(Key key, SecureRandom random) throws InvalidKeyException {
        throw new UnsupportedOperationException();
    }

    private void initFromKey(Key key) throws InvalidKeyException {
        if (!(key instanceof MQVPrivateKey)) {
            throw new InvalidKeyException(this.kaAlgorithm + " key agreement requires " + KeyAgreementSpi.getSimpleName(MQVPrivateKey.class) + " for initialisation");
        }
        MQVPrivateKey mqvPrivKey = (MQVPrivateKey)key;
        ECPrivateKeyParameters staticPrivKey = (ECPrivateKeyParameters)ECUtil.generatePrivateKeyParameter(mqvPrivKey.getStaticPrivateKey());
        ECPrivateKeyParameters ephemPrivKey = (ECPrivateKeyParameters)ECUtil.generatePrivateKeyParameter(mqvPrivKey.getEphemeralPrivateKey());
        ECPublicKeyParameters ephemPubKey = null;
        if (mqvPrivKey.getEphemeralPublicKey() != null) {
            ephemPubKey = (ECPublicKeyParameters)ECUtil.generatePublicKeyParameter(mqvPrivKey.getEphemeralPublicKey());
        }
        MQVPrivateParameters localParams = new MQVPrivateParameters(staticPrivKey, ephemPrivKey, ephemPubKey);
        this.parameters = staticPrivKey.getParameters();
        this.agreement.init(localParams);
    }

    private static String getSimpleName(Class clazz) {
        String fullName = clazz.getName();
        return fullName.substring(fullName.lastIndexOf(46) + 1);
    }

    static {
        algorithms.put(GMTObjectIdentifiers.id_sm4_CBC.getId(), Integers.valueOf(256));
    }

    public static class SM2DH
    extends KeyAgreementSpi {
        public SM2DH() {
            super("SM2DH", new SM2MQVBasicAgreement(), new KDF2BytesGenerator(new SM3Digest()));
        }
    }
}

