/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.signature;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKCSObjectIdentifiers;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import cfca.sadk.org.bouncycastle.asn1.ASN1Object;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.DERNull;
import cfca.sadk.org.bouncycastle.asn1.pkcs.IssuerAndSerialNumber;
import cfca.sadk.org.bouncycastle.asn1.sm2.ASN1SM2Signature;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.signature.AbstractPKCS7Package;
import cfca.sadk.signature.sm2.SM2SignerInfo;
import cfca.sadk.system.global.SM2ContextConfig;

final class PKCS7SM2PackageUtil
extends AbstractPKCS7Package {
    PKCS7SM2PackageUtil() {
    }

    public ASN1Object getSignerInfo(byte[] signature, IssuerAndSerialNumber issuerAndSn, Mechanism mechanism) throws PKIException {
        SM2SignerInfo signerInfo;
        if (signature == null || signature.length != 64) {
            throw new PKIException("PKCS7SignedData@packageSM2SignedData required signature 64-bytes");
        }
        ASN1SM2Signature signData = ASN1SM2Signature.convertFrom64SignBytes(signature);
        ASN1Integer derR = signData.getR();
        ASN1Integer derS = signData.getS();
        AlgorithmIdentifier digestEncryptAlgIdentifier = null;
        AlgorithmIdentifier digestAlgIdentifier = this.getDigestAlgIdentifier(mechanism);
        if (SM2ContextConfig.getSignFormat() == 3) {
            digestEncryptAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.SM2_sign, DERNull.INSTANCE);
            signerInfo = new SM2SignerInfo(signInfoVersion, issuerAndSn, digestAlgIdentifier, null, digestEncryptAlgIdentifier, derR, derS, null);
        } else if (SM2ContextConfig.getSignFormat() == 2) {
            digestEncryptAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.sm2Encryption, DERNull.INSTANCE);
            signerInfo = new SM2SignerInfo(signInfoVersion, issuerAndSn, digestAlgIdentifier, null, digestEncryptAlgIdentifier, derR, derS, null);
        } else {
            digestEncryptAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.sm2Encryption, DERNull.INSTANCE);
            signerInfo = new SM2SignerInfo(signInfoVersion, issuerAndSn, digestAlgIdentifier, null, digestEncryptAlgIdentifier, derR, derS, null);
        }
        return signerInfo;
    }

    public AlgorithmIdentifier getDigestAlgIdentifier(Mechanism mechanism) throws PKIException {
        return new AlgorithmIdentifier(PKCSObjectIdentifiers.sm3, DERNull.INSTANCE);
    }

    public ASN1ObjectIdentifier getContentIdentifier() throws PKIException {
        return PKCSObjectIdentifiers.sm2Data;
    }

    public ASN1ObjectIdentifier getSignDataIdentifier() throws PKIException {
        return PKCSObjectIdentifiers.sm2SignedData;
    }
}

