/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.signature.rsa;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.asn1.parser.ASN1Parser;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.org.bouncycastle.asn1.ASN1Set;
import cfca.sadk.org.bouncycastle.asn1.pkcs.AuthenticatedAttributesUtil;
import cfca.sadk.org.bouncycastle.crypto.Digest;
import cfca.sadk.org.bouncycastle.crypto.Signer;
import cfca.sadk.org.bouncycastle.crypto.params.RSAKeyParameters;
import cfca.sadk.org.bouncycastle.crypto.signers.RSADigestSigner;
import cfca.sadk.system.FileHelper;
import cfca.sadk.system.Mechanisms;
import cfca.sadk.system.logging.LoggerManager;
import cfca.sadk.util.HashUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.security.Key;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;

public class RSASignUtil {
    static final int fileBufferSize = 65536;

    public static boolean verifySign(String digestAlgorithm, Key pubKey, byte[] sourceData, byte[] signature) throws PKIException {
        if (sourceData == null || signature == null) {
            return false;
        }
        Signer signer = RSASignUtil.getSigner(digestAlgorithm);
        if ("SM2".equalsIgnoreCase(pubKey.getAlgorithm())) {
            return false;
        }
        RSAPublicKey publicKey = (RSAPublicKey)pubKey;
        RSAKeyParameters pubParameter = RSASignUtil.generatePublicKeyParameter(publicKey);
        signer.init(false, pubParameter);
        try {
            signer.update(sourceData, 0, sourceData.length);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.VERIFY_SIGN, PKIException.VERIFY_SIGN_DES, e);
        }
        return signer.verifySignature(signature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean verifySignFile(String digestAlgorithm, Key pubKey, String sourceFilePath, byte[] signature) throws Exception {
        if (sourceFilePath == null || signature == null) {
            return false;
        }
        Signer signer = RSASignUtil.getSigner(digestAlgorithm);
        RSAPublicKey publicKey = (RSAPublicKey)pubKey;
        RSAKeyParameters pubParameter = RSASignUtil.generatePublicKeyParameter(publicKey);
        signer.init(false, pubParameter);
        BufferedInputStream bfis = new BufferedInputStream(new FileInputStream(sourceFilePath));
        try {
            int buffer_size = 65536;
            byte[] buffer = new byte[buffer_size];
            int i = bfis.read(buffer);
            if (i == -1) {
                throw new Exception("the source data is null!");
            }
            do {
                signer.update(buffer, 0, i);
            } while ((i = bfis.read(buffer)) != -1);
            Object var12_11 = null;
            if (bfis == null) return signer.verifySignature(signature);
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            if (bfis == null) throw throwable;
            bfis.close();
            throw throwable;
        }
        bfis.close();
        return signer.verifySignature(signature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean verifySignFile(String digestAlgorithm, Key pubKey, String sourceFilePath, long startPos, long dataLength, byte[] signature, String generate_sourceFilePath) throws Exception {
        boolean bl;
        FileOutputStream gen_fos;
        block14: {
            RandomAccessFile bfis;
            block11: {
                boolean bl2;
                block12: {
                    bfis = null;
                    gen_fos = null;
                    if (sourceFilePath != null && signature != null) break block11;
                    bl2 = false;
                    Object var20_11 = null;
                    if (bfis == null) break block12;
                    bfis.close();
                }
                if (gen_fos != null) {
                    gen_fos.close();
                }
                return bl2;
            }
            try {
                byte[] buffer;
                Signer signer = RSASignUtil.getSigner(digestAlgorithm);
                RSAPublicKey publicKey = (RSAPublicKey)pubKey;
                RSAKeyParameters pubParameter = RSASignUtil.generatePublicKeyParameter(publicKey);
                signer.init(false, pubParameter);
                bfis = new RandomAccessFile(new File(sourceFilePath), "r");
                bfis.seek(startPos);
                if (generate_sourceFilePath != null && !generate_sourceFilePath.trim().equals("")) {
                    gen_fos = new FileOutputStream(generate_sourceFilePath);
                }
                if (dataLength > 65536L) {
                    int readLen;
                    buffer = new byte[65536];
                    for (long readTotalLen = 0L; (readLen = bfis.read(buffer)) > 0 && readTotalLen < dataLength; readTotalLen += (long)readLen) {
                        if (readTotalLen + (long)readLen <= dataLength) {
                            signer.update(buffer, 0, readLen);
                            FileHelper.writeBytesToFile(buffer, 0, readLen, gen_fos);
                            continue;
                        }
                        int left = (int)(dataLength - readTotalLen);
                        signer.update(buffer, 0, left);
                        FileHelper.writeBytesToFile(buffer, 0, left, gen_fos);
                        break;
                    }
                } else {
                    buffer = new byte[(int)dataLength];
                    int i = bfis.read(buffer);
                    signer.update(buffer, 0, i);
                    FileHelper.writeBytesToFile(buffer, 0, i, gen_fos);
                }
                bl = signer.verifySignature(signature);
                Object var20_12 = null;
                if (bfis == null) break block14;
            }
            catch (Throwable throwable) {
                block15: {
                    Object var20_13 = null;
                    if (bfis != null) {
                        bfis.close();
                    }
                    if (gen_fos == null) break block15;
                    gen_fos.close();
                }
                throw throwable;
            }
            bfis.close();
        }
        if (gen_fos != null) {
            gen_fos.close();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] calculateDigest(String digestAlgorithm, InputStream sourceFileStream) throws Exception {
        byte[] digest = null;
        if (sourceFileStream == null) {
            return null;
        }
        Digest engine = RSASignUtil.getDigestEngine(digestAlgorithm);
        BufferedInputStream bfis = new BufferedInputStream(sourceFileStream);
        try {
            int buffer_size = 65536;
            byte[] buffer = new byte[buffer_size];
            int readTotalLen = bfis.read(buffer);
            if (readTotalLen == -1) {
                throw new Exception("the source data is null!");
            }
            do {
                engine.update(buffer, 0, readTotalLen);
            } while ((readTotalLen = bfis.read(buffer)) != -1);
            digest = new byte[engine.getDigestSize()];
            engine.doFinal(digest, 0);
            Object var9_8 = null;
            if (bfis == null) return digest;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (bfis == null) throw throwable;
            bfis.close();
            throw throwable;
        }
        bfis.close();
        return digest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] calculateDigest(String digestAlgorithm, String sourceFilePath, long startPos, long dataLength, String generate_sourceFilePath) throws Exception {
        byte[] digest;
        FileOutputStream gen_fos;
        block15: {
            RandomAccessFile bfis;
            block12: {
                byte[] byArray;
                block13: {
                    bfis = null;
                    gen_fos = null;
                    digest = null;
                    if (sourceFilePath != null) break block12;
                    byArray = null;
                    Object var17_10 = null;
                    if (bfis == null) break block13;
                    bfis.close();
                }
                if (gen_fos != null) {
                    gen_fos.close();
                }
                return byArray;
            }
            try {
                Digest engine = RSASignUtil.getDigestEngine(digestAlgorithm);
                bfis = new RandomAccessFile(new File(sourceFilePath), "r");
                bfis.seek(startPos);
                if (generate_sourceFilePath != null && !generate_sourceFilePath.trim().equals("")) {
                    gen_fos = new FileOutputStream(generate_sourceFilePath);
                }
                if (dataLength > 65536L) {
                    int readLen;
                    byte[] buffer = new byte[65536];
                    for (long readTotalLen = 0L; (readLen = bfis.read(buffer)) > 0 && readTotalLen < dataLength; readTotalLen += (long)readLen) {
                        if (readTotalLen + (long)readLen <= dataLength) {
                            engine.update(buffer, 0, readLen);
                            FileHelper.writeBytesToFile(buffer, 0, readLen, gen_fos);
                            continue;
                        }
                        int left = (int)(dataLength - readTotalLen);
                        engine.update(buffer, 0, left);
                        FileHelper.writeBytesToFile(buffer, 0, left, gen_fos);
                        break;
                    }
                } else {
                    byte[] buffer = new byte[(int)dataLength];
                    int i = bfis.read(buffer);
                    engine.update(buffer, 0, i);
                    FileHelper.writeBytesToFile(buffer, 0, i, gen_fos);
                }
                digest = new byte[engine.getDigestSize()];
                engine.doFinal(digest, 0);
                Object var17_11 = null;
                if (bfis == null) break block15;
            }
            catch (Throwable throwable) {
                Object var17_12 = null;
                if (bfis != null) {
                    bfis.close();
                }
                if (gen_fos != null) {
                    gen_fos.close();
                }
                throw throwable;
            }
            bfis.close();
        }
        if (gen_fos != null) {
            gen_fos.close();
        }
        return digest;
    }

    public static boolean verifySignData(Mechanism digestAlgorithm, Key pubKey, byte[] content, byte[] signature, ASN1Set authAttributes, Session session) throws Exception {
        boolean forJNILib = session != null && session.useJniNativeOperation();
        byte[] contentDigest = null;
        contentDigest = forJNILib ? HashUtil.RSAHashMessageByJNI(content, digestAlgorithm, false) : HashUtil.RSAHashMessageByBC(content, digestAlgorithm, false);
        return RSASignUtil.verifySignDegist(digestAlgorithm, pubKey, contentDigest, signature, authAttributes, session);
    }

    public static boolean verifySignFile(Mechanism digestAlgorithm, Key pubKey, InputStream sourceFileStream, byte[] signature, ASN1Set authAttributes, Session session) throws Exception {
        byte[] contentDigest = RSASignUtil.calculateDigest(digestAlgorithm.getMechanismType(), sourceFileStream);
        return RSASignUtil.verifySignDegist(digestAlgorithm, pubKey, contentDigest, signature, authAttributes, session);
    }

    public static boolean verifySignFile(Mechanism digestAlgorithm, Key pubKey, String sourceFilePath, long startPos, long dataLength, byte[] signature, String generate_sourceFilePath, ASN1Set authAttributes, Session session) throws Exception {
        byte[] contentDigest = RSASignUtil.calculateDigest(digestAlgorithm.getMechanismType(), sourceFilePath, startPos, dataLength, generate_sourceFilePath);
        return RSASignUtil.verifySignDegist(digestAlgorithm, pubKey, contentDigest, signature, authAttributes, session);
    }

    private static boolean verifySignDegist(Mechanism digestAlgorithm, Key pubKey, byte[] contentDigest, byte[] signature, ASN1Set authAttributes, Session session) throws Exception {
        byte[] originDigest = null;
        if (authAttributes != null) {
            byte[] authAttributesDigest = AuthenticatedAttributesUtil.getMessageDigest(authAttributes);
            boolean verifyAuthAttributesDigest = Arrays.equals(contentDigest, authAttributesDigest);
            if (!verifyAuthAttributesDigest) {
                LoggerManager.exceptionLogger.error("verifySignDegist failed: the Digest of SourceData is not equals with Digest in authAttributes!");
                return false;
            }
            byte[] bAuthAttries = ASN1Parser.parseDERObj2Bytes(authAttributes);
            originDigest = HashUtil.RSAHashMessageByBC(bAuthAttries, digestAlgorithm, false);
        } else {
            originDigest = contentDigest;
        }
        return session.verifyByHash(digestAlgorithm, (PublicKey)pubKey, originDigest, signature);
    }

    private static Signer getSigner(String digestAlgorithm) throws PKIException {
        Digest engine = Mechanisms.getDigest(digestAlgorithm);
        if (engine == null) {
            throw new PKIException("can not support this degest algorithm:" + digestAlgorithm);
        }
        return new RSADigestSigner(engine);
    }

    private static Digest getDigestEngine(String digestAlgorithm) throws PKIException {
        Digest engine = Mechanisms.getDigest(digestAlgorithm);
        if (engine == null) {
            throw new PKIException("can not support this degest algorithm:" + digestAlgorithm);
        }
        return engine;
    }

    private static RSAKeyParameters generatePublicKeyParameter(RSAPublicKey key) {
        return new RSAKeyParameters(false, key.getModulus(), key.getPublicExponent());
    }
}

